package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.Device;
import com.flybits.commons.library.models.internal.DevicesResponse;
import com.flybits.commons.library.models.Pagination;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;

public class DeserializeDevices implements IDeserializer<Result<DevicesResponse>>{

    @Override
    public String toJson(Result<DevicesResponse> obj) {
        return null;
    }

    @Override
    public Result<DevicesResponse> fromJson(String json) {

        Result<DevicesResponse> user = new Result<>();

        try {
            JSONObject jObj = new JSONObject(json);

            if (!jObj.isNull("exceptionType")){
                user.responseStatus    = RequestStatus.FAILED;

                if (!jObj.isNull("exceptionMessage")){
                    user.exception         = new ServerException(jObj.getString("exceptionMessage"));
                }

                if (user.exception != null && !jObj.isNull("exceptionType")){
                    user.exception.exceptionType = jObj.getString("exceptionType");
                }

                if (user.exception != null && !jObj.isNull("dateTime")) {
                    String date = jObj.getString("dateTime");
                    try {
                        Calendar calendar       = TimeUtilities.toCalendarT(date);
                        if (calendar != null) {
                            user.exception.dateTime = calendar.getTimeInMillis();
                        }else{
                            user.exception.dateTime = -1;
                        }
                    }catch(ParseException exceptionArgs){
                        user.exception.dateTime = -1;
                    }
                }
            }else{
                user.response               = new DevicesResponse();
                if (!jObj.isNull("pagination")){

                    JSONObject paginationObj        = jObj.getJSONObject("pagination");
                    user.response.pagination        = new Pagination();

                    if (paginationObj.has("offset")){
                        user.response.pagination.offset = paginationObj.getLong("offset");
                    }

                    if (paginationObj.has("limit")){
                        user.response.pagination.limit = paginationObj.getLong("limit");
                    }

                    if (paginationObj.has("totalRecords")){
                        user.response.pagination.totalRecords = paginationObj.getLong("totalRecords");
                    }
                }

                if (!jObj.isNull("data")){
                    user.response.devices       = new ArrayList<>();
                    user.responseStatus         = RequestStatus.SUCCESS;
                    JSONArray dataArray = jObj.getJSONArray("data");
                    for (int i = 0; i < dataArray.length(); i++) {

                        Device device = new Device();
                        JSONObject elementObj   = dataArray.getJSONObject(i);

                        if (!elementObj.isNull("id")){
                            device.id           = elementObj.getString("id");
                        }
                        if (!elementObj.isNull("physicalId")){
                            device.physicalId   = elementObj.getString("physicalId");
                        }
                        if (!elementObj.isNull("type")){
                            device.type         = Device.Type.fromKey(elementObj.getString("type"));
                        }
                        if (!elementObj.isNull("createdAt")){
                            String date = elementObj.getString("createdAt");
                            try {
                                Calendar calendar       = TimeUtilities.toCalendarT(date);
                                if (calendar != null) {
                                    device.createdAt = calendar.getTimeInMillis();
                                }else{
                                    device.createdAt = -1;
                                }
                            }catch(ParseException exceptionArgs){
                                device.createdAt = -1;
                            }
                        }
                        user.response.devices.add(device);
                    }
                }else{
                    user.responseStatus    = RequestStatus.FAILED;
                    user.exception         = new ServerException("There was a server issue detected");
                }
            }
        }catch (JSONException e){
            user.responseStatus    = RequestStatus.FAILED;
            user.exception         = new ServerException("Error Parsing Response");
        }
        return user;
    }
}
