package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.Device;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.Calendar;

public class DeserializeDevice implements IDeserializer<Result<Device>>{

    @Override
    public String toJson(Result<Device> obj) {
        return null;
    }

    @Override
    public Result<Device> fromJson(String json) {

        Result<Device> device = new Result<>();

        try {
            JSONObject jObj = new JSONObject(json);

            if (!jObj.isNull("exceptionType")){
                device.responseStatus    = RequestStatus.FAILED;

                if (!jObj.isNull("exceptionMessage")){
                    device.exception         = new ServerException(jObj.getString("exceptionMessage"));
                }

                if (device.exception != null && !jObj.isNull("exceptionType")){
                    device.exception.exceptionType = jObj.getString("exceptionType");
                }

                if (device.exception != null && !jObj.isNull("dateTime")) {
                    String date = jObj.getString("dateTime");
                    try {
                        Calendar calendar       = TimeUtilities.toCalendarT(date);
                        if (calendar != null) {
                            device.exception.dateTime = calendar.getTimeInMillis();
                        }else{
                            device.exception.dateTime = -1;
                        }
                    }catch(ParseException exceptionArgs){
                        device.exception.dateTime = -1;
                    }
                }
            }else{


                if (!jObj.isNull("id")){
                    device.response             = new Device();
                    device.responseStatus       = RequestStatus.SUCCESS;
                    device.response.id = jObj.getString("id");

                    if (!jObj.isNull("physicalId")){
                        device.response.physicalId  = jObj.getString("physicalId");
                    }

                    if (!jObj.isNull("type")){
                        device.response.type        = Device.Type.fromKey(jObj.getString("type"));
                    }

                    if (!jObj.isNull("createdAt")) {
                        String date = jObj.getString("createdAt");
                        try {
                            Calendar calendar       = TimeUtilities.toCalendarT(date);
                            if (calendar != null) {
                                device.response.createdAt = calendar.getTimeInMillis();
                            }else{
                                device.response.createdAt = -1;
                            }
                        }catch(ParseException exceptionArgs){
                            device.response.createdAt = -1;
                        }
                    }
                }else{
                    device.responseStatus    = RequestStatus.FAILED;
                    device.exception         = new ServerException("There was a server issue detected");
                }
            }
        }catch (JSONException e){
            device.responseStatus    = RequestStatus.FAILED;
            device.exception         = new ServerException("Error Parsing Response");
        }
        return device;
    }
}
