package com.flybits.commons.library.api;

import android.content.Context;

import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.deserializations.DeserializeGetJWT;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.exceptions.InvalidFlybitsResponseException;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.GetRequest;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.JWTToken;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.internal.ServerResult;

import java.io.IOException;

public class FlyJWT {


    public static Result<JWTToken> refreshJWT(Context context) throws InvalidFlybitsResponseException, FlybitsDisabledException {

        String url = FlybitsAPIConstants.constructURL((FlybitsAPIConstants.API_USER + FlybitsAPIConstants.API_JWT));

        try {
            ServerResult result = new GetRequest(context, url).getResponse();

            Result<JWTToken> info = new DeserializeGetJWT().fromJson(result.response);
            info.responseAsString = result.response;

            if ( info.responseStatus == RequestStatus.SUCCESS) {
                SharedElements.setJWTToken(context, info.response.payload);
            } else if (result.status == 404){
                info.responseStatus = RequestStatus.NOT_FOUND;
                info.exception  = new ServerException("Error Connecting to Flybits Server: FlyException_JWT1a");
            } else {
                info.responseStatus = RequestStatus.FAILED;
                info.response       = null;
            }

            return info;
        } catch (IOException | NullPointerException e) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(e);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_JWT1b");
        }
    }

}
