package com.flybits.commons.library.api;

import android.content.Context;

import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.deserializations.DeserializeDevice;
import com.flybits.commons.library.deserializations.DeserializeDevices;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.exceptions.InvalidFlybitsRequestException;
import com.flybits.commons.library.exceptions.InvalidFlybitsResponseException;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.GetRequest;
import com.flybits.commons.library.http.PostRequest;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.Device;
import com.flybits.commons.library.models.internal.DevicesResponse;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.internal.ServerResult;
import com.flybits.commons.library.utils.Utilities;

import java.io.IOException;

public class FlyDevice {

    //DONE
    public static Result<DevicesResponse> getDevices(Context context) throws InvalidFlybitsResponseException, FlybitsDisabledException {

        String url = FlybitsAPIConstants.constructURL(FlybitsAPIConstants.API_DEVICES);

        try {
            ServerResult result = new GetRequest(context, url, null).getResponse();
            Result<DevicesResponse> info = new DeserializeDevices().fromJson(result.response);

            if (result.status == 404){
                info.responseStatus = RequestStatus.NOT_FOUND;
                info.exception      = new ServerException("Error Connecting to Flybits Server: FlyException_Device1");
            }else if (info.responseStatus != RequestStatus.SUCCESS){
                info.response       = null;
            }

            info.responseAsString = result.response;
            return info;
        } catch (IOException | NullPointerException e) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(e);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Device1");
        }
    }

    //DONE
    public static Result<Device> addToDevices(Context context) throws InvalidFlybitsResponseException, InvalidFlybitsRequestException, FlybitsDisabledException {

        String url  = FlybitsAPIConstants.constructURL(FlybitsAPIConstants.API_DEVICES);
        String json = new DeviceInfo(context).toJson();

        try {
            ServerResult result = new PostRequest(context, false, url, json, null).getResponse();
            Result<Device> info = new DeserializeDevice().fromJson(result.response);

            if (result.status == 404){
                info.responseStatus = RequestStatus.NOT_FOUND;
                info.exception      = new ServerException("Error Connecting to Flybits Server: FlyException_Device1");
            }else if (info.responseStatus != RequestStatus.SUCCESS){
                info.response       = null;
            }

            info.responseAsString = result.response;
            return  info;
        } catch (IOException | NullPointerException e1) {
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Device2");
        }
    }

    static class DeviceInfo{
        public String physicalId;
        public DeviceInfo(Context mContext){
            this.physicalId = Utilities.getDeviceID(mContext);
        }

        public String toJson(){
            return "{\"physicalId\" : \"" +physicalId+ "\"}";
        }
    }
}
