/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flybits.commons.library.models.CtxData;
import com.flybits.commons.library.models.State;
import com.flybits.internal.db.CtxDataDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class CtxDataDAO_Impl
implements CtxDataDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CtxData> __insertionAdapterOfCtxData;
    private final EntityDeletionOrUpdateAdapter<CtxData> __deletionAdapterOfCtxData;
    private final EntityDeletionOrUpdateAdapter<CtxData> __updateAdapterOfCtxData;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public CtxDataDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCtxData = new EntityInsertionAdapter<CtxData>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ctxData` (`id`,`timestamp`,`value`,`pluginID`,`state`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CtxData value) {
                stmt.bindLong(1, value.getId());
                stmt.bindLong(2, value.getTimestamp());
                if (value.getValue() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getValue());
                }
                if (value.getPluginID() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPluginID());
                }
                if (value.getState() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, CtxDataDAO_Impl.this.__State_enumToString(value.getState()));
                }
            }
        };
        this.__deletionAdapterOfCtxData = new EntityDeletionOrUpdateAdapter<CtxData>(__db){

            public String createQuery() {
                return "DELETE FROM `ctxData` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CtxData value) {
                stmt.bindLong(1, value.getId());
            }
        };
        this.__updateAdapterOfCtxData = new EntityDeletionOrUpdateAdapter<CtxData>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `ctxData` SET `id` = ?,`timestamp` = ?,`value` = ?,`pluginID` = ?,`state` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CtxData value) {
                stmt.bindLong(1, value.getId());
                stmt.bindLong(2, value.getTimestamp());
                if (value.getValue() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getValue());
                }
                if (value.getPluginID() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPluginID());
                }
                if (value.getState() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, CtxDataDAO_Impl.this.__State_enumToString(value.getState()));
                }
                stmt.bindLong(6, value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from ctxData";
                return "DELETE from ctxData";
            }
        };
    }

    @Override
    public void insert(CtxData basicData) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCtxData.insert((Object)basicData);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteMany(Collection<CtxData> ctxData) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCtxData.handleMultiple(ctxData);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateCtxData(Collection<CtxData> ctxData) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCtxData.handleMultiple(ctxData);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CtxData> getAll() {
        String _sql = "SELECT * from ctxData";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from ctxData", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"value");
            int _cursorIndexOfPluginID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pluginID");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            ArrayList<CtxData> _result = new ArrayList<CtxData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                String _tmpValue = _cursor.isNull(_cursorIndexOfValue) ? null : _cursor.getString(_cursorIndexOfValue);
                String _tmpPluginID = _cursor.isNull(_cursorIndexOfPluginID) ? null : _cursor.getString(_cursorIndexOfPluginID);
                State _tmpState = this.__State_stringToEnum(_cursor.getString(_cursorIndexOfState));
                CtxData _item = new CtxData(_tmpId, _tmpTimestamp, _tmpValue, _tmpPluginID, _tmpState);
                _result.add(_item);
            }
            ArrayList<CtxData> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CtxData> getAllByState(State state) {
        String _sql = "SELECT * from ctxData where state = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from ctxData where state = ?", (int)1);
        int _argIndex = 1;
        if (state == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, this.__State_enumToString(state));
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"value");
            int _cursorIndexOfPluginID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pluginID");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            ArrayList<CtxData> _result = new ArrayList<CtxData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                String _tmpValue = _cursor.isNull(_cursorIndexOfValue) ? null : _cursor.getString(_cursorIndexOfValue);
                String _tmpPluginID = _cursor.isNull(_cursorIndexOfPluginID) ? null : _cursor.getString(_cursorIndexOfPluginID);
                State _tmpState = this.__State_stringToEnum(_cursor.getString(_cursorIndexOfState));
                CtxData _item = new CtxData(_tmpId, _tmpTimestamp, _tmpValue, _tmpPluginID, _tmpState);
                _result.add(_item);
            }
            ArrayList<CtxData> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CtxData> getDataByDataTypeID(String pluginID) {
        String _sql = "SELECT * from ctxData where pluginID = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from ctxData where pluginID = ?", (int)1);
        int _argIndex = 1;
        if (pluginID == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pluginID);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"value");
            int _cursorIndexOfPluginID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pluginID");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            ArrayList<CtxData> _result = new ArrayList<CtxData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                String _tmpValue = _cursor.isNull(_cursorIndexOfValue) ? null : _cursor.getString(_cursorIndexOfValue);
                String _tmpPluginID = _cursor.isNull(_cursorIndexOfPluginID) ? null : _cursor.getString(_cursorIndexOfPluginID);
                State _tmpState = this.__State_stringToEnum(_cursor.getString(_cursorIndexOfState));
                CtxData _item = new CtxData(_tmpId, _tmpTimestamp, _tmpValue, _tmpPluginID, _tmpState);
                _result.add(_item);
            }
            ArrayList<CtxData> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CtxData getDataByValue(String value) {
        String _sql = "SELECT * from ctxData WHERE value = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from ctxData WHERE value = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (value == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, value);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            CtxData _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"value");
            int _cursorIndexOfPluginID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pluginID");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            if (_cursor.moveToFirst()) {
                long _tmpId = _cursor.getLong(_cursorIndexOfId);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                String _tmpValue = _cursor.isNull(_cursorIndexOfValue) ? null : _cursor.getString(_cursorIndexOfValue);
                String _tmpPluginID = _cursor.isNull(_cursorIndexOfPluginID) ? null : _cursor.getString(_cursorIndexOfPluginID);
                State _tmpState = this.__State_stringToEnum(_cursor.getString(_cursorIndexOfState));
                _result = new CtxData(_tmpId, _tmpTimestamp, _tmpValue, _tmpPluginID, _tmpState);
            } else {
                _result = null;
            }
            CtxData ctxData = _result;
            return ctxData;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __State_enumToString(State _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case PENDING: {
                return "PENDING";
            }
            case INFLIGHT: {
                return "INFLIGHT";
            }
            case DELIVERED: {
                return "DELIVERED";
            }
        }
        throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + (Object)((Object)_value));
    }

    private State __State_stringToEnum(String _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case "PENDING": {
                return State.PENDING;
            }
            case "INFLIGHT": {
                return State.INFLIGHT;
            }
            case "DELIVERED": {
                return State.DELIVERED;
            }
        }
        throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
}

