/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.ScopeOfficer;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.DeserializeLogin;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.internal.db.CommonsDatabase;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Entity(tableName="user", indices={@Index(value={"customerID"}, unique=true)})
public class User
implements Parcelable {
    private static final String FIELD_DEVICE_ID = "deviceID";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_FIRST_NAME = "firstName";
    public static final String FIELD_ID = "id";
    public static final String FIELD_LAST_NAME = "lastName";
    private static final String FIELD_IS_VERIFIED = "isVerified";
    public static final String FIELD_IS_OPTED_IN = "isOptedIn";
    public static final String FIELD_IS_ACTIVE = "isActive";
    public static final String FIELD_CUSTOMER_ID = "customerID";
    public static final String ME_ENDPOINT = "/sso/auth/me";
    @ColumnInfo(name="deviceID")
    private String deviceID;
    @ColumnInfo(name="email")
    private String email;
    @ColumnInfo(name="firstName")
    private String firstName;
    @PrimaryKey
    @ColumnInfo(name="id")
    @NonNull
    private String id;
    @ColumnInfo(name="lastName")
    private String lastName;
    @ColumnInfo(name="isVerified")
    private boolean isVerified;
    @ColumnInfo(name="isOptedIn")
    private boolean isOptedIn;
    @ColumnInfo(name="isActive")
    private boolean isActive;
    @ColumnInfo(name="customerID")
    @Nullable
    private String customerID;
    public static final Parcelable.Creator<User> CREATOR = new Parcelable.Creator<User>(){

        public User createFromParcel(Parcel in) {
            return new User(in);
        }

        public User[] newArray(int size) {
            return new User[size];
        }
    };

    public User() {
    }

    @Ignore
    public User(Parcel in) {
        this.id = in.readString();
        this.firstName = in.readString();
        this.lastName = in.readString();
        this.email = in.readString();
        this.deviceID = in.readString();
        this.isVerified = in.readInt() == 1;
        this.isOptedIn = in.readInt() == 1;
        this.isActive = in.readInt() == 1;
        this.customerID = in.readString();
    }

    @Ignore
    public User(@NonNull String id, @NonNull String email, @NonNull String deviceID) {
        this.deviceID = deviceID;
        this.email = email;
        this.id = id;
    }

    @Ignore
    public User(@NonNull User user) {
        this.deviceID = user.deviceID;
        this.email = user.email;
        this.id = user.id;
        this.firstName = user.firstName;
        this.lastName = user.lastName;
    }

    @Ignore
    public String toString() {
        return "User: id->" + this.id + ", email-> " + this.email + ", firstName-> " + this.firstName + ", lastName-> " + this.lastName + ", customerId-> " + this.customerID + ", deviceId-> " + this.deviceID + ", isVerified-> " + this.isVerified + ", isOptedIn-> " + this.isOptedIn + ", isActive-> " + this.isActive;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public boolean isOptedIn() {
        return this.isOptedIn;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Nullable
    public String getCustomerID() {
        return this.customerID;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIsVerified(boolean isVerified) {
        this.isVerified = isVerified;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setName(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public void setOptedIn(boolean isOptedIn) {
        this.isOptedIn = isOptedIn;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setCustomerID(@Nullable String customerID) {
        this.customerID = customerID;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User another = (User)o;
        return another.id.equals(this.id);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.id);
        out.writeString(this.firstName);
        out.writeString(this.lastName);
        out.writeString(this.email);
        out.writeString(this.deviceID);
        out.writeInt(this.isVerified ? 1 : 0);
        out.writeInt(this.isOptedIn ? 1 : 0);
        out.writeInt(this.isActive ? 1 : 0);
        out.writeString(this.customerID);
    }

    public static ObjectResult<User> getSelf(Context context) {
        return User.getSelf(context, null);
    }

    public static ObjectResult<User> getSelf(final Context context, ObjectResultCallback<User> callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult<User> request = new ObjectResult<User>(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                Result<User> getUser = FlyAway.get(context, User.ME_ENDPOINT, new DeserializeLogin(), "FlybitsManager.get", User.class);
                if (getUser.getStatus() == RequestStatus.COMPLETED) {
                    User user = getUser.getResponse();
                    CommonsDatabase.getDatabase(context).userDao().update(user);
                    ScopeOfficer.INSTANCE.onOptedStateChange(context, user.isOptedIn);
                }
                if (getUser.getStatus() == RequestStatus.COMPLETED) {
                    request.setResult(getUser);
                } else {
                    request.setFailed(getUser.getException());
                }
            }
        });
        return request;
    }

    public static ObjectResult<User> getSelf(Context context, ObjectResultCallback<User> callback) {
        return User.getSelf(context, callback, new Handler(Looper.getMainLooper()));
    }
}

