package com.flybits.internal.db

import androidx.room.*
import androidx.room.OnConflictStrategy.REPLACE
import com.flybits.commons.library.models.CtxData
import com.flybits.commons.library.models.State

@Dao
interface CtxDataDAO {
    @Query("SELECT * from ctxData")
    fun getAll(): List<CtxData>

    @Query("SELECT * from ctxData where state = :state")
    fun getAllByState(state: State): List<CtxData>

    @Query("SELECT * from ctxData where pluginID = :pluginID")
    fun getDataByDataTypeID(pluginID: String): List<CtxData>

    @Update
    fun updateCtxData(ctxData: Collection<CtxData>)

    @Insert(onConflict = REPLACE)
    fun insert(basicData: CtxData)

    @Query("DELETE from ctxData")
    fun deleteAll()

    @Query("SELECT * from ctxData WHERE value = :value LIMIT 1")
    fun getDataByValue(value: String): CtxData?

    @Delete
    fun deleteMany(ctxData: Collection<CtxData>)
}