package com.flybits.internal.db;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.flybits.internal.db.models.CachingEntry;

import java.util.List;

@Dao
public interface CachingEntryDAO {

    /**
     * GET
     */
    @Query("SELECT contentID FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    List<String> getIdsByCachingKey(String key);

    //Selects only the content ids which only appear across the entire table once, if two caching entries contain the same content id, they will not be returned here.
    @Query("SELECT contentId FROM ( SELECT contentID, sequence, cachingkey FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = :key ORDER BY sequence ASC")
    List<String> getUniqueIdsByCachingKey(String key);

    @Query("SELECT * FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    List<CachingEntry> getByKey(String key);

    //Selects only the content ids which only appear across the entire table once, if two caching entries contain the same content id, they will not be returned here.
    @Query("SELECT * FROM ( SELECT * FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = :key ORDER BY sequence ASC")
    List<CachingEntry> getUniqueByKey(String key);

    /**
     * CREATE/INSERT/DELETE
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(CachingEntry entry);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(List<CachingEntry> entry);

    @Query("Delete from cachingentry")
    void clear();

    @Query("Delete from cachingentry WHERE cachingkey = :key")
    void deleteAllByCachingKey(String key);

    @Query("Delete from cachingentry WHERE cachingkey = :key AND contentID = :value")
    void deleteByCachingKeyAndValue(String key, String value);

    /**
     * LIVEDATA
     */
    @Query("SELECT * FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    LiveData<List<CachingEntry>> getLive(String key);
}
