package com.flybits.commons.library.models.internal;

/**
 * A class that represents paging information about the SDK request.
 */
public class Pagination {

    private long limit = -1;
    private long offset = 0;
    private long totalRecords = -1;

    /**
     * Constructor that defines all the variables for the {@code Pagination}.
     *
     * @param limit The maximum number of objects returned for a request.
     * @param offset Integer value representing the starting record/object for a request.
     */
    public Pagination(long limit, long offset){
        this.limit          = limit;
        this.offset         = offset;
    }

    /**
     * Constructor that defines all the variables for the {@code Pagination}.
     *
     * @param limit The maximum number of objects returned for a request.
     * @param offset Integer value representing the starting record/object for a request.
     * @param totalRecords The total number of records/objects that can be returned for a request.
     */
    public Pagination(long limit, long offset, long totalRecords){
        this(limit, offset);
        this.totalRecords   = totalRecords;
    }

    /**
     * Get the number maximum number of items returned for a request. For example, if there are 20
     * items that need to be retrieved using a paging technique but you would only like to get 10
     * at a time, the limit would be 10.
     *
     * @return The maximum number of objects returned for a request.
     */
    public long getLimit() {
        return limit;
    }

    /**
     * Get the offset item based on which items should be retrieved. For example, if there are 20
     * items that need to be retrieved using a paging technique if you would like to get items 5 to
     * 10 you offset will need to be 5. If you would like to get the first 5 items your offset
     * should be 0.
     *
     * @return Integer value representing the starting record/object for a request.
     */
    public long getOffset() {
        return offset;
    }

    /**
     * Get the total number of items that can be returned for a request. For example, if you make a
     * request that returns a total of 10 items then this item will be represented by a 10.
     *
     * @return The total number of records/objects that can be returned for a request.
     */
    public long getTotalRecords() {
        return totalRecords;
    }
}
