package com.flybits.commons.library.models

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey

/**
 * This class represents a piece of ctx data with an id, timestamp and value. It can be used
 * for storing a version of an object in json string format prior to sending it to the server.
 *
 * @param timestamp Store in milliseconds in local database to help in sorting, retrieving.
 *
 */
@Entity(tableName = "ctxData")
data class CtxData(@ColumnInfo(name = "id") @PrimaryKey(autoGenerate = true) var id: Long = 0,
        @ColumnInfo(name = "timestamp") var timestamp: Long, @ColumnInfo(name = "value") var value: String,
        @ColumnInfo(name = "pluginID") val pluginID: String?,
        @ColumnInfo(name = "state") var state: State = State.PENDING)

/***
 * This is a sate machine that use to mark the reporting sate of the CTX data
 */
enum class State(val value: String) {

    /**
     * Indicates that the context data has been entered in the Database and needs to be sent to the
     * server.
     */
    PENDING("pending"),

    /**
     * Indicates that the context data has been sent to the server, we still don't know if it was
     * successfully sent or not
     */
    INFLIGHT("inflight"),

    /**
     * Indicates that the context data was successfully sent to the server.
     */
    DELIVERED("delivered");
}