package com.flybits.commons.library.exceptions;

/**
 * The {@code MissingProjectIDException} class represents an exception that was thrown by a the
 * Flybits Core during a request to the server in order to obtain specific information.
 *
 * @since 1.0.0
 */
public class MissingProjectIDException extends RuntimeException{

    /**
     * Constructs an empty {@code MissingProjectIDException}.
     */
    public MissingProjectIDException(){}

    /**
     * Constructs a new {@code MissingProjectIDException} with a specified message indicating why
     * the exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public MissingProjectIDException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code MissingProjectIDException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public MissingProjectIDException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code MissingProjectIDException} with the specified detail message and the
     * specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public MissingProjectIDException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}
