package com.flybits.commons.library.deserializations;


import com.flybits.commons.library.logging.Logger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class DeserializeListResponse<T> extends IDeserializer<ArrayList<T>> {

    private IDeserializer deserializer;

    public DeserializeListResponse(IDeserializer deserializer){
        this.deserializer   = deserializer;
    }

    @Override
    public String toJson(ArrayList<T> obj) {
        JSONArray object   = new JSONArray();
        return object.toString();
    }

    @Override
    public ArrayList<T> fromJson(JSONObject jObj) {
        try {
            if (!jObj.isNull(KEY_LIST_ITEM)) {
                ArrayList<T> items = new ArrayList<>();

                JSONArray dataArray = jObj.getJSONArray(KEY_LIST_ITEM);
                for (int i = 0; i < dataArray.length(); i++) {
                    JSONObject elementObj = dataArray.getJSONObject(i);
                    T deserializedItem  = (T) deserializer.fromJson(elementObj);
                    if (deserializedItem != null) {
                        items.add(deserializedItem);
                    }
                }
                return new ArrayList<T>(items);
            }
        }catch (JSONException e){
            Logger.exception("DeserializePagedResponse.fromJson", e);
        }
        return null;
    }

    @Override
    public ArrayList<T> fromJson(JSONArray jsonObject) {
        return null;
    }
}
