package com.flybits.commons.library.api.results.callbacks

import com.flybits.commons.library.models.internal.Pagination

/**
 * Callback used to indicate whether or not the network request for a list response was successful
 * or not.
 *
 * @param <T> The item that is expected to be returned as a list for this query.
 */
interface PagedResultCallback<T> : BaseCallback {

    /**
     * Indicates that the network request was successful.
     *
     * @param items The item that is expected to be returned as a list for this query.
     * @param pagination The [Pagination] object that indicates the total number of records
     * for this request, as well the number of items returned and from which offset.
     */
    fun onSuccess(items : ArrayList<T>, pagination : Pagination)

    /**
     * Indicates that all the items in the list have been loaded
     */
    fun onLoadedAllItems()
}