package com.flybits.commons

import android.content.Context
import com.flybits.commons.library.SharedElementsFactory
import com.flybits.commons.library.api.FlybitsScope
import com.flybits.commons.library.api.ScopeAuthState
import com.flybits.commons.library.logging.Logger
import com.flybits.commons.library.models.Device
import com.flybits.commons.library.models.User
import com.google.firebase.installations.FirebaseInstallations
import java.util.*

const val TAG = "CommonScope"

class CommonScope private constructor() : FlybitsScope("CommonScope") {

    lateinit var context: Context

    constructor(context: Context) : this() {
        this.context = context
    }

    override fun onOptedStateChange(context: Context, optedState: Boolean) {
    }

    override fun onFailedToConnect() {
        // No-op
    }

    override fun onConnecting() {
        // No-op
    }

    override fun onConnected(context: Context, user: User) {
    }

    override fun onDisconnected(context: Context) {
    }

    override fun onStart(authState: ScopeAuthState) {
        Logger.appendTag(TAG).d("CommonScope onStart() called.")
        val sharedElements = SharedElementsFactory.get(context)
        if (sharedElements.getUniqueDeviceId().isBlank()) {
            FirebaseInstallations.getInstance().id.addOnSuccessListener { instanceIdResult ->
                sharedElements.setUniqueDevice(instanceIdResult)
                if (sharedElements.getSavedJWTToken().isBlank()) {
                    Logger.appendTag(TAG).d("User not logged In.")
                } else {
                    Device.addAssociationMigration(context, instanceIdResult)
                    Logger.appendTag(TAG).d("Added a Firebase physical device identifier.")
                }
            }.addOnFailureListener {
                sharedElements.setUniqueDevice(UUID.randomUUID().toString())
            }
        } else {
            Logger.appendTag(TAG).d("physicalDevice is unchanged.")
        }
    }

    override fun onStop() {
    }
}