/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.util.Log;
import android.webkit.URLUtil;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.models.PushProviderType;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/flybits/commons/library/api/FlybitsConfiguration;", "", "builder", "Lcom/flybits/commons/library/api/FlybitsConfiguration$Builder;", "(Lcom/flybits/commons/library/api/FlybitsConfiguration$Builder;)V", "applicationContext", "Landroid/content/Context;", "getApplicationContext", "()Landroid/content/Context;", "gatewayUrl", "", "getGatewayUrl", "()Ljava/lang/String;", "setGatewayUrl", "(Ljava/lang/String;)V", "projectId", "getProjectId", "setProjectId", "pushProviderFromJson", "getPushProviderFromJson", "setPushProviderFromJson", "Builder", "Companion", "commons_release"})
public final class FlybitsConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @NotNull
    private String projectId;
    @NotNull
    private String gatewayUrl;
    @NotNull
    private String pushProviderFromJson;
    @NotNull
    public static final String CONFIGURATION_FILE_NAME = "FlybitsConfiguration.json";
    @NotNull
    public static final String CONFIGURATION_PARSER_TAG = "FlybitsConfigParser";
    @NotNull
    public static final String PROJECT_CONFIG_JSON = "projectConfiguration";
    @NotNull
    public static final String PROJECT_ID_JSON = "projectId";
    @NotNull
    public static final String GATEWAY_URL_JSON = "gatewayUrl";
    @NotNull
    public static final String PUSH_PROVIDER = "pushProvider";

    private FlybitsConfiguration(Builder builder) {
        this.applicationContext = builder.getApplicationContext();
        this.projectId = Builder.Companion.getProjectId();
        this.gatewayUrl = Builder.Companion.getGatewayUrl();
        this.pushProviderFromJson = Builder.Companion.getPushProviderFromJson();
    }

    @NotNull
    public final Context getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    public final void setProjectId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.projectId = string;
    }

    @NotNull
    public final String getGatewayUrl() {
        return this.gatewayUrl;
    }

    public final void setGatewayUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.gatewayUrl = string;
    }

    @NotNull
    public final String getPushProviderFromJson() {
        return this.pushProviderFromJson;
    }

    public final void setPushProviderFromJson(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pushProviderFromJson = string;
    }

    public /* synthetic */ FlybitsConfiguration(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/flybits/commons/library/api/FlybitsConfiguration$Companion;", "", "()V", "CONFIGURATION_FILE_NAME", "", "CONFIGURATION_PARSER_TAG", "GATEWAY_URL_JSON", "PROJECT_CONFIG_JSON", "PROJECT_ID_JSON", "PUSH_PROVIDER", "commons_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/flybits/commons/library/api/FlybitsConfiguration$Builder;", "", "applicationContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getApplicationContext", "()Landroid/content/Context;", "build", "Lcom/flybits/commons/library/api/FlybitsConfiguration;", "setGateWayUrl", "gatewayUrl", "", "setProjectId", "projectId", "setPushProviderType", "pushProviderType", "Companion", "commons_release"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Context applicationContext;
        @NotNull
        private static String projectId = "";
        @NotNull
        private static String gatewayUrl = "";
        @NotNull
        private static String pushProviderFromJson = "";

        public Builder(@NotNull Context applicationContext) {
            Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
            this.applicationContext = applicationContext;
        }

        @NotNull
        public final Context getApplicationContext() {
            return this.applicationContext;
        }

        @NotNull
        public final Builder setProjectId(@NotNull String projectId) {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)FlybitsConfiguration.PROJECT_ID_JSON);
            Builder.projectId = projectId;
            return this;
        }

        @NotNull
        public final Builder setGateWayUrl(@NotNull String gatewayUrl) {
            Intrinsics.checkNotNullParameter((Object)gatewayUrl, (String)FlybitsConfiguration.GATEWAY_URL_JSON);
            if (!URLUtil.isHttpsUrl((String)gatewayUrl)) {
                String errorMessage = StringsKt.trimIndent((String)("\n                   \ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\n                   \ud83d\udea8 Using a non HTTPS url: " + gatewayUrl + "\n                   \ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\ud83d\udea8\n                "));
                Log.w((String)"FlybitsConfiguration", (String)errorMessage);
            }
            Builder.gatewayUrl = gatewayUrl;
            return this;
        }

        @NotNull
        public final Builder setPushProviderType(@NotNull String pushProviderType) {
            Intrinsics.checkNotNullParameter((Object)pushProviderType, (String)"pushProviderType");
            String string = pushProviderType;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            switch (string2) {
                case "gcm": {
                    SharedElementsFactory.INSTANCE.get(this.applicationContext).storePushProviderType(PushProviderType.GCM);
                    break;
                }
                case "fcm": {
                    SharedElementsFactory.INSTANCE.get(this.applicationContext).storePushProviderType(PushProviderType.FCM);
                    break;
                }
                case "huawei": {
                    SharedElementsFactory.INSTANCE.get(this.applicationContext).storePushProviderType(PushProviderType.HUAWEI);
                }
            }
            return this;
        }

        @NotNull
        public final FlybitsConfiguration build() {
            return new FlybitsConfiguration(this, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/flybits/commons/library/api/FlybitsConfiguration$Builder$Companion;", "", "()V", "<set-?>", "", "gatewayUrl", "getGatewayUrl", "()Ljava/lang/String;", "projectId", "getProjectId", "pushProviderFromJson", "getPushProviderFromJson", "setPushProviderFromJson$commons_release", "(Ljava/lang/String;)V", "commons_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getProjectId() {
                return projectId;
            }

            @NotNull
            public final String getGatewayUrl() {
                return gatewayUrl;
            }

            @NotNull
            public final String getPushProviderFromJson() {
                return pushProviderFromJson;
            }

            public final void setPushProviderFromJson$commons_release(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                pushProviderFromJson = string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

