/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKeys;
import com.flybits.commons.library.SecuredSharedElements;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsInMemory;
import com.flybits.commons.library.UnsecuredSharedElements;
import com.flybits.commons.library.logging.Logger;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.UserDAO;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/flybits/commons/library/SharedElementsFactory;", "", "()V", "fallbackToMemory", "", "retainSharedPref", "savedInstance", "Lcom/flybits/commons/library/SharedElements;", "createEncryptedSharedPreference", "context", "Landroid/content/Context;", "userDAO", "Lcom/flybits/internal/db/UserDAO;", "createEncryptedSharedPreference$commons_release", "get", "commons_release"})
public final class SharedElementsFactory {
    @NotNull
    public static final SharedElementsFactory INSTANCE = new SharedElementsFactory();
    private static boolean fallbackToMemory;
    private static boolean retainSharedPref;
    @JvmField
    @Nullable
    public static volatile SharedElements savedInstance;

    private SharedElementsFactory() {
    }

    @NotNull
    public final SharedElements get(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedElements sharedElements = savedInstance;
        if (sharedElements == null) {
            sharedElements = this.get(context, fallbackToMemory, retainSharedPref);
        }
        return sharedElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SharedElements get(@NotNull Context context, boolean fallbackToMemory, boolean retainSharedPref) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedElementsFactory.fallbackToMemory = fallbackToMemory;
        SharedElementsFactory.retainSharedPref = retainSharedPref;
        SharedElements sharedElements = savedInstance;
        if (sharedElements == null) {
            SharedElementsFactory sharedElementsFactory = this;
            synchronized (sharedElementsFactory) {
                boolean bl = false;
                UserDAO userDAO = CommonsDatabase.getDatabase(context).userDao();
                SharedElements sharedElements2 = savedInstance;
                if (sharedElements2 == null) {
                    SharedElements sharedElements3;
                    try {
                        String string = SharedElements.Companion.getTAG$commons_release();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedElements.TAG");
                        Logger.appendTag(string).d("get(): Creating first instance of SharedElements");
                        Intrinsics.checkNotNullExpressionValue((Object)userDAO, (String)"userDAO");
                        SharedElements it = sharedElements3 = INSTANCE.createEncryptedSharedPreference$commons_release(context, userDAO);
                        boolean bl2 = false;
                        savedInstance = it;
                    }
                    catch (Exception e) {
                        SharedElements sharedElements4;
                        UnsecuredSharedElements it;
                        SharedElements sharedElements5;
                        Logger.exception("SharedElementsFactory.INSTANCE.get()", e);
                        if (!fallbackToMemory) {
                            String string = SharedElements.Companion.getTAG$commons_release();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedElements.TAG");
                            Logger.appendTag(string).d("Creating instance of UnsecuredSharedElements");
                            SharedPreferences sharedPreferences = context.getSharedPreferences("FLYBITS_PREF", 0);
                            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026                        )");
                            Intrinsics.checkNotNullExpressionValue((Object)userDAO, (String)"userDAO");
                            it = sharedElements5 = new UnsecuredSharedElements(sharedPreferences, userDAO);
                            boolean bl3 = false;
                            savedInstance = it;
                            sharedElements4 = sharedElements5;
                        } else {
                            String string = SharedElements.Companion.getTAG$commons_release();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedElements.TAG");
                            Logger.appendTag(string).d("Creating instance of SharedElementsInMemory");
                            SharedPreferences sharedPreferences = context.getSharedPreferences("FLYBITS_PREF", 0);
                            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026                        )");
                            Intrinsics.checkNotNullExpressionValue((Object)userDAO, (String)"userDAO");
                            it = sharedElements5 = new SharedElementsInMemory(sharedPreferences, userDAO, SharedElementsFactory.retainSharedPref);
                            boolean bl4 = false;
                            savedInstance = it;
                            sharedElements4 = sharedElements5;
                        }
                        sharedElements3 = sharedElements4;
                    }
                    sharedElements2 = sharedElements3;
                }
                SharedElements sharedElements6 = sharedElements2;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 8] lbl59 : MonitorExitStatement: MONITOREXIT : var4_4
                sharedElements = sharedElements6;
            }
        }
        return sharedElements;
    }

    public static /* synthetic */ SharedElements get$default(SharedElementsFactory sharedElementsFactory, Context context, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return sharedElementsFactory.get(context, bl, bl2);
    }

    @NotNull
    public final synchronized SharedElements createEncryptedSharedPreference$commons_release(@NotNull Context context, @NotNull UserDAO userDAO) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)userDAO, (String)"userDAO");
        String string = MasterKeys.getOrCreate((KeyGenParameterSpec)MasterKeys.AES256_GCM_SPEC);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrCreate(MasterKeys.AES256_GCM_SPEC)");
        String masterKeyAlias = string;
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((String)"flybits_secure_storage_v3", (String)masterKeyAlias, (Context)context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n                \u2026heme.AES256_GCM\n        )");
        SharedPreferences pref = sharedPreferences;
        return new SecuredSharedElements(pref, userDAO);
    }

    static {
        retainSharedPref = true;
    }
}

