/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidJsonFormatException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.JsonParser;
import com.flybits.commons.library.models.internal.Result;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/flybits/commons/library/models/Project;", "", "id", "", "creatorId", "name", "subdomain", "tierId", "isActive", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getCreatorId", "()Ljava/lang/String;", "getId", "()Z", "getName", "getSubdomain", "getTierId", "Companion", "commons_release"})
public final class Project {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String creatorId;
    @NotNull
    private final String name;
    @NotNull
    private final String subdomain;
    @NotNull
    private final String tierId;
    private final boolean isActive;
    @NotNull
    private static final String URL_SETTINGS = "/sso/settings/configs";
    @NotNull
    private static final String TYPE_PROJECT_SETTINGS = "project-settings";

    public Project(@NotNull String id, @NotNull String creatorId, @NotNull String name, @NotNull String subdomain, @NotNull String tierId, boolean isActive) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)creatorId, (String)"creatorId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)subdomain, (String)"subdomain");
        Intrinsics.checkNotNullParameter((Object)tierId, (String)"tierId");
        this.id = id;
        this.creatorId = creatorId;
        this.name = name;
        this.subdomain = subdomain;
        this.tierId = tierId;
        this.isActive = isActive;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getCreatorId() {
        return this.creatorId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getSubdomain() {
        return this.subdomain;
    }

    @NotNull
    public final String getTierId() {
        return this.tierId;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u0002H\b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJG\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u0002H\b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012JG\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u0002H\b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0015JO\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u0002H\b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/flybits/commons/library/models/Project$Companion;", "", "()V", "TYPE_PROJECT_SETTINGS", "", "URL_SETTINGS", "getProjectSettings", "Lcom/flybits/commons/library/api/results/ObjectResult;", "T", "Lcom/flybits/commons/library/models/JsonParser;", "context", "Landroid/content/Context;", "clazz", "callback", "Lcom/flybits/commons/library/api/results/callbacks/ObjectResultCallback;", "(Landroid/content/Context;Lcom/flybits/commons/library/models/JsonParser;Lcom/flybits/commons/library/api/results/callbacks/ObjectResultCallback;)Lcom/flybits/commons/library/api/results/ObjectResult;", "handler", "Landroid/os/Handler;", "(Landroid/content/Context;Lcom/flybits/commons/library/models/JsonParser;Lcom/flybits/commons/library/api/results/callbacks/ObjectResultCallback;Landroid/os/Handler;)Lcom/flybits/commons/library/api/results/ObjectResult;", "getSettings", "type", "(Ljava/lang/String;Landroid/content/Context;Lcom/flybits/commons/library/models/JsonParser;Lcom/flybits/commons/library/api/results/callbacks/ObjectResultCallback;)Lcom/flybits/commons/library/api/results/ObjectResult;", "(Ljava/lang/String;Landroid/content/Context;Lcom/flybits/commons/library/models/JsonParser;Lcom/flybits/commons/library/api/results/callbacks/ObjectResultCallback;Landroid/os/Handler;)Lcom/flybits/commons/library/api/results/ObjectResult;", "commons_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends JsonParser> ObjectResult<T> getProjectSettings(@Nullable Context context, T clazz, @Nullable ObjectResultCallback<T> callback, @NotNull Handler handler) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            return this.getSettings(Project.TYPE_PROJECT_SETTINGS, context, clazz, callback, handler);
        }

        @NotNull
        public final <T extends JsonParser> ObjectResult<T> getProjectSettings(@Nullable Context context, T clazz, @Nullable ObjectResultCallback<T> callback) {
            return this.getSettings(Project.TYPE_PROJECT_SETTINGS, context, clazz, callback, new Handler(Looper.getMainLooper()));
        }

        @NotNull
        public final <T extends JsonParser> ObjectResult<T> getSettings(@NotNull String type, @Nullable Context context, T clazz, @Nullable ObjectResultCallback<T> callback) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.getSettings(type, context, clazz, callback, new Handler(Looper.getMainLooper()));
        }

        @NotNull
        public final <T extends JsonParser> ObjectResult<T> getSettings(@NotNull String type, @Nullable Context context, T clazz, @Nullable ObjectResultCallback<T> callback, @NotNull Handler handler) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executorService");
            ObjectResult<T> request = new ObjectResult<T>(callback, handler, executorService);
            executorService.execute(() -> Companion.getSettings$lambda-0(type, context, clazz, request));
            return request;
        }

        private static final void getSettings$lambda-0(String $type, Context $context, JsonParser $clazz, ObjectResult $request) {
            Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
            Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
            try {
                String string = "%s/%s";
                Object[] objectArray = new Object[]{Project.URL_SETTINGS, $type};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                String url = string2;
                Context context = $context;
                Intrinsics.checkNotNull((Object)context);
                Result getSettings = FlyAway.get(context, url, null, "Project.GetSettings", null);
                if (getSettings.getStatus() == RequestStatus.COMPLETED) {
                    String response = getSettings.getResponseAsString();
                    JSONObject object = new JSONObject(response);
                    if (!object.isNull("settings")) {
                        JSONObject settingsObject = object.getJSONObject("settings");
                        JsonParser jsonParser = $clazz;
                        Intrinsics.checkNotNull((Object)jsonParser);
                        jsonParser.fromJson(settingsObject.toString());
                        $request.setSuccess($clazz);
                    } else {
                        $request.setFailed(new InvalidJsonFormatException());
                    }
                } else if (getSettings.getStatus() == RequestStatus.NOT_FOUND) {
                    $request.setSuccess($clazz);
                } else {
                    $request.setResult(getSettings);
                }
            }
            catch (FlybitsException e) {
                $request.setFailed(e);
            }
            catch (ClassCastException e) {
                FlybitsException exception = new FlybitsException(e);
                $request.setFailed(exception);
            }
            catch (JSONException e) {
                FlybitsException exception = new FlybitsException(e);
                $request.setFailed(exception);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

