/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.utils.Utilities;
import com.flybits.internal.db.UserDAO;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/flybits/commons/library/SharedElementsInMemory;", "Lcom/flybits/commons/library/SharedElements;", "sharedPreferences", "Landroid/content/SharedPreferences;", "userDAO", "Lcom/flybits/internal/db/UserDAO;", "keepSP", "", "(Landroid/content/SharedPreferences;Lcom/flybits/internal/db/UserDAO;Z)V", "performMigration", "", "context", "Landroid/content/Context;", "setBooleanVariable", "", "key", "", "value", "setStringVariable", "commons_release"})
public final class SharedElementsInMemory
extends SharedElements {
    private boolean keepSP;

    public SharedElementsInMemory(@NotNull SharedPreferences sharedPreferences, @NotNull UserDAO userDAO, boolean keepSP) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkNotNullParameter((Object)userDAO, (String)"userDAO");
        super(sharedPreferences, userDAO, null, 4, null);
        this.keepSP = keepSP;
    }

    public /* synthetic */ SharedElementsInMemory(SharedPreferences sharedPreferences, UserDAO userDAO, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(sharedPreferences, userDAO, bl);
    }

    @Override
    protected int performMigration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences backupPreferences = context.getSharedPreferences("FLYBITS_PREF_BACKUP", 0);
        int migratedCount = 0;
        if (backupPreferences.contains("com.flybits.jwt.token")) {
            String string = backupPreferences.getString("com.flybits.jwt.token", "");
            if (string == null) {
                string = "";
            }
            this.setJWTToken(string);
            ++migratedCount;
        }
        if (backupPreferences.contains("com.flybits.idp.connected")) {
            String string = backupPreferences.getString("com.flybits.idp.connected", "");
            if (string == null) {
                string = "";
            }
            this.setConnectedIDP(string);
            ++migratedCount;
        }
        if (backupPreferences.contains("com.flybits.language.codes")) {
            this.setLocalization(Utilities.convertLocalizationStringToList(backupPreferences.getString("com.flybits.language.codes", "")));
            ++migratedCount;
        }
        if (migratedCount > 0) {
            backupPreferences.edit().clear().apply();
        }
        if (this.keepSP) {
            return migratedCount;
        }
        if (this.getSharedPreferences().contains("com.flybits.jwt.token")) {
            this.getSharedPreferences().edit().putString("com.flybits.jwt.token", "").apply();
            ++migratedCount;
        }
        if (this.getSharedPreferences().contains("com.flybits.idp.connected")) {
            this.getSharedPreferences().edit().putString("com.flybits.idp.connected", "").apply();
            ++migratedCount;
        }
        return migratedCount;
    }

    @Override
    public void setStringVariable(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = key;
        if (StringsKt.contains$default((CharSequence)"com.flybits.jwt.token", (CharSequence)string, (boolean)false, (int)2, null) ? true : Intrinsics.areEqual((Object)string, (Object)"com.flybits.idp.connected")) {
            return;
        }
        this.getSharedPreferences().edit().putString(key, value).apply();
    }

    @Override
    public void setBooleanVariable(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key;
        if (StringsKt.contains$default((CharSequence)"com.flybits.jwt.token", (CharSequence)string, (boolean)false, (int)2, null) ? true : Intrinsics.areEqual((Object)string, (Object)"com.flybits.idp.connected")) {
            return;
        }
        this.getSharedPreferences().edit().putBoolean(key, value).apply();
    }
}

