package com.flybits.internal

import android.content.Context
import com.flybits.commons.library.analytics.Analytics
import com.flybits.commons.library.api.results.BasicResult
import com.flybits.commons.library.exceptions.FlybitsException
import java.util.concurrent.TimeUnit

class DebouncerAnalyticsReporting(val context: Context,
        val result: BasicResult? = null)
    : Debounce("ANALYTICS_REPORT", 1, TimeUnit.SECONDS) {

    override fun doSomething() {
        Analytics(context).flush({ success: Boolean, exception: Exception? ->
            result?.let {
                if (success) {
                    result.setSuccess()
                } else {
                    result.setFailed(FlybitsException(exception))
                }
            }
        })
    }
}