package com.flybits.commons.library.encryption

import android.content.SharedPreferences
import com.flybits.commons.library.logging.Logger
import java.security.KeyStore
import java.security.KeyStoreException
class DefaultRecoveryHandler : RecoveryHandler() {
    override fun recover(
        e: Exception,
        keyStore: KeyStore?,
        keyAliases: List<String?>?,
        preferences: SharedPreferences?
    ): Boolean {
        Logger.appendTag(TAG).e(TAG_EXCEPTION, e)
        try {
            clearKeyStore(keyStore, keyAliases)
            clearPreferences(preferences)
            return true
        } catch (e1: KeyStoreException) {
            Logger.appendTag(TAG).e(TAG_EXCEPTION, e1)
        }
        return false
    }
}