/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.sdk.ext.paging;

import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0007%&'()*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\b\u0010\u001a\u001a\u00020\u0015H\u0003J\u001a\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010!\u001a\u00020\u0010J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000\f8\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper;", "", "mRetryService", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "mListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Listener;", "getMListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "mLock", "mRequestQueues", "", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestQueue;", "[Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestQueue;", "addListener", "", "listener", "dispatchReport", "", "report", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$StatusReport;", "getStatusForLocked", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;", "type", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;", "prepareStatusReportLocked", "recordResult", "wrapper", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestWrapper;", "throwable", "", "removeListener", "retryAllFailed", "runIfNotRunning", "request", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request;", "Listener", "Request", "RequestQueue", "RequestType", "RequestWrapper", "Status", "StatusReport", "swallow_release"})
public final class PagingRequestHelper {
    private final Object mLock;
    @GuardedBy(value="mLock")
    private final RequestQueue[] mRequestQueues;
    @NotNull
    private final CopyOnWriteArrayList<Listener> mListeners;
    private final Executor mRetryService;

    @NotNull
    public final CopyOnWriteArrayList<Listener> getMListeners() {
        return this.mListeners;
    }

    @AnyThread
    public final boolean addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.mListeners.add(listener);
    }

    public final boolean removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.mListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final boolean runIfNotRunning(@NotNull RequestType type, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean hasListeners = !this.mListeners.isEmpty();
        StatusReport report = null;
        Object object = this.mLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            RequestQueue queue;
            block6: {
                boolean bl3 = false;
                queue = this.mRequestQueues[type.ordinal()];
                if (queue.getMRunning() == null) break block6;
                boolean bl4 = false;
                return bl4;
            }
            queue.setMRunning(request);
            queue.setMStatus(Status.RUNNING);
            queue.setMFailed(null);
            queue.setMLastError(null);
            if (hasListeners) {
                report = this.prepareStatusReportLocked();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (report != null) {
            StatusReport statusReport = report;
            Intrinsics.checkNotNull((Object)statusReport);
            this.dispatchReport(statusReport);
        }
        RequestWrapper wrapper = new RequestWrapper(request, this, type);
        wrapper.run();
        return true;
    }

    @GuardedBy(value="mLock")
    private final StatusReport prepareStatusReportLocked() {
        Throwable[] errors = new Throwable[]{this.mRequestQueues[0].getMLastError(), this.mRequestQueues[1].getMLastError(), this.mRequestQueues[2].getMLastError()};
        return new StatusReport(this.getStatusForLocked(RequestType.INITIAL), this.getStatusForLocked(RequestType.BEFORE), this.getStatusForLocked(RequestType.AFTER), errors);
    }

    @GuardedBy(value="mLock")
    private final Status getStatusForLocked(RequestType type) {
        return this.mRequestQueues[type.ordinal()].getMStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @VisibleForTesting
    public final void recordResult(@NotNull RequestWrapper wrapper, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        StatusReport report = null;
        boolean success = throwable == null;
        boolean hasListeners = !this.mListeners.isEmpty();
        Object object = this.mLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            RequestQueue queue = this.mRequestQueues[wrapper.getMType().ordinal()];
            queue.setMRunning(null);
            queue.setMLastError(throwable);
            if (success) {
                queue.setMFailed(null);
                queue.setMStatus(Status.SUCCESS);
            } else {
                queue.setMFailed(wrapper);
                queue.setMStatus(Status.FAILED);
            }
            if (hasListeners) {
                report = this.prepareStatusReportLocked();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (report != null) {
            StatusReport statusReport = report;
            Intrinsics.checkNotNull((Object)statusReport);
            this.dispatchReport(statusReport);
        }
    }

    private final void dispatchReport(StatusReport report) {
        for (Listener listener : this.mListeners) {
            listener.onStatusChange(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean retryAllFailed() {
        RequestWrapper[] toBeRetried = new RequestWrapper[RequestType.values().length];
        boolean retried = false;
        Object object = this.mLock;
        int n = 0;
        boolean bl = false;
        synchronized (object) {
            boolean bl2 = false;
            int n2 = 0;
            int n3 = RequestType.values().length;
            while (n2 < n3) {
                void i;
                toBeRetried[i] = this.mRequestQueues[i].getMFailed();
                this.mRequestQueues[i].setMFailed(null);
                ++i;
            }
            RequestWrapper[] requestWrapperArray = Unit.INSTANCE;
        }
        for (RequestWrapper failed : toBeRetried) {
            if (failed == null) continue;
            failed.retry(this.mRetryService);
            retried = true;
        }
        return retried;
    }

    public PagingRequestHelper(@NotNull Executor mRetryService) {
        Intrinsics.checkNotNullParameter((Object)mRetryService, (String)"mRetryService");
        this.mRetryService = mRetryService;
        this.mLock = new Object();
        this.mRequestQueues = new RequestQueue[]{new RequestQueue(RequestType.INITIAL), new RequestQueue(RequestType.BEFORE), new RequestQueue(RequestType.AFTER)};
        this.mListeners = new CopyOnWriteArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestWrapper;", "Ljava/lang/Runnable;", "mRequest", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request;", "mHelper", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper;", "mType", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;", "(Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request;Lcom/swallow/sdk/ext/paging/PagingRequestHelper;Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;)V", "getMHelper", "()Lcom/swallow/sdk/ext/paging/PagingRequestHelper;", "getMRequest", "()Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request;", "getMType", "()Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;", "retry", "", "service", "Ljava/util/concurrent/Executor;", "run", "swallow_release"})
    public static final class RequestWrapper
    implements Runnable {
        @NotNull
        private final Request mRequest;
        @NotNull
        private final PagingRequestHelper mHelper;
        @NotNull
        private final RequestType mType;

        @Override
        public void run() {
            this.mRequest.run(new Request.Callback(this, this.mHelper));
        }

        public final void retry(@NotNull Executor service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            service.execute(new Runnable(this){
                final /* synthetic */ RequestWrapper this$0;

                public final void run() {
                    this.this$0.getMHelper().runIfNotRunning(this.this$0.getMType(), this.this$0.getMRequest());
                }
                {
                    this.this$0 = requestWrapper;
                }
            });
        }

        @NotNull
        public final Request getMRequest() {
            return this.mRequest;
        }

        @NotNull
        public final PagingRequestHelper getMHelper() {
            return this.mHelper;
        }

        @NotNull
        public final RequestType getMType() {
            return this.mType;
        }

        public RequestWrapper(@NotNull Request mRequest, @NotNull PagingRequestHelper mHelper, @NotNull RequestType mType) {
            Intrinsics.checkNotNullParameter((Object)mRequest, (String)"mRequest");
            Intrinsics.checkNotNullParameter((Object)mHelper, (String)"mHelper");
            Intrinsics.checkNotNullParameter((Object)((Object)mType), (String)"mType");
            this.mRequest = mRequest;
            this.mHelper = mHelper;
            this.mType = mType;
        }
    }

    @FunctionalInterface
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request;", "", "run", "", "callback", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request$Callback;", "Callback", "swallow_release"})
    public static interface Request {
        public void run(@NotNull Callback var1);

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request$Callback;", "", "mWrapper", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestWrapper;", "mHelper", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper;", "(Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestWrapper;Lcom/swallow/sdk/ext/paging/PagingRequestHelper;)V", "mCalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "recordFailure", "", "throwable", "", "recordSuccess", "swallow_release"})
        public static final class Callback {
            private final AtomicBoolean mCalled;
            private final RequestWrapper mWrapper;
            private final PagingRequestHelper mHelper;

            public final void recordSuccess() {
                if (!this.mCalled.compareAndSet(false, true)) {
                    throw (Throwable)new IllegalStateException("already called recordSuccess or recordFailure");
                }
                this.mHelper.recordResult(this.mWrapper, null);
            }

            public final void recordFailure(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                boolean bl = false;
                boolean bl2 = false;
                if (!this.mCalled.compareAndSet(false, true)) {
                    throw (Throwable)new IllegalStateException("already called recordSuccess or recordFailure");
                }
                this.mHelper.recordResult(this.mWrapper, throwable);
            }

            public Callback(@NotNull RequestWrapper mWrapper, @NotNull PagingRequestHelper mHelper) {
                Intrinsics.checkNotNullParameter((Object)mWrapper, (String)"mWrapper");
                Intrinsics.checkNotNullParameter((Object)mHelper, (String)"mHelper");
                this.mWrapper = mWrapper;
                this.mHelper = mHelper;
                this.mCalled = new AtomicBoolean();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper$StatusReport;", "", "initial", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;", "before", "after", "mErrors", "", "", "(Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;[Ljava/lang/Throwable;)V", "getAfter", "()Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;", "getBefore", "getInitial", "[Ljava/lang/Throwable;", "equals", "", "o", "getErrorFor", "type", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;", "hasError", "hasRunning", "hashCode", "", "toString", "", "swallow_release"})
    public static final class StatusReport {
        @NotNull
        private final Status initial;
        @NotNull
        private final Status before;
        @NotNull
        private final Status after;
        private final Throwable[] mErrors;

        public final boolean hasRunning() {
            return this.initial == Status.RUNNING || this.before == Status.RUNNING || this.after == Status.RUNNING;
        }

        public final boolean hasError() {
            return this.initial == Status.FAILED || this.before == Status.FAILED || this.after == Status.FAILED;
        }

        @Nullable
        public final Throwable getErrorFor(@NotNull RequestType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return this.mErrors[type.ordinal()];
        }

        @NotNull
        public String toString() {
            return "StatusReport{initial=" + (Object)((Object)this.initial) + ", before=" + (Object)((Object)this.before) + ", after=" + (Object)((Object)this.after) + ", mErrors=" + Arrays.toString(this.mErrors) + '}';
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || Intrinsics.areEqual(this.getClass(), o.getClass()) ^ true) {
                return false;
            }
            StatusReport that = (StatusReport)o;
            if (this.initial != that.initial) {
                return false;
            }
            if (this.before != that.before) {
                return false;
            }
            return this.after != that.after ? false : Arrays.equals(this.mErrors, that.mErrors);
        }

        public int hashCode() {
            int result = this.initial.hashCode();
            result = 31 * result + this.before.hashCode();
            result = 31 * result + this.after.hashCode();
            result = 31 * result + Arrays.hashCode(this.mErrors);
            return result;
        }

        @NotNull
        public final Status getInitial() {
            return this.initial;
        }

        @NotNull
        public final Status getBefore() {
            return this.before;
        }

        @NotNull
        public final Status getAfter() {
            return this.after;
        }

        public StatusReport(@NotNull Status initial, @NotNull Status before, @NotNull Status after, @NotNull Throwable[] mErrors) {
            Intrinsics.checkNotNullParameter((Object)((Object)initial), (String)"initial");
            Intrinsics.checkNotNullParameter((Object)((Object)before), (String)"before");
            Intrinsics.checkNotNullParameter((Object)((Object)after), (String)"after");
            Intrinsics.checkNotNullParameter((Object)mErrors, (String)"mErrors");
            this.initial = initial;
            this.before = before;
            this.after = after;
            this.mErrors = mErrors;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Listener;", "", "onStatusChange", "", "report", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$StatusReport;", "swallow_release"})
    public static interface Listener {
        public void onStatusChange(@NotNull StatusReport var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;", "", "(Ljava/lang/String;I)V", "RUNNING", "SUCCESS", "FAILED", "swallow_release"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status RUNNING;
        public static final /* enum */ Status SUCCESS;
        public static final /* enum */ Status FAILED;
        private static final /* synthetic */ Status[] $VALUES;

        static {
            Status[] statusArray = new Status[3];
            Status[] statusArray2 = statusArray;
            statusArray[0] = RUNNING = new Status();
            statusArray[1] = SUCCESS = new Status();
            statusArray[2] = FAILED = new Status();
            $VALUES = statusArray;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string2) {
            return Enum.valueOf(Status.class, string2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;", "", "(Ljava/lang/String;I)V", "INITIAL", "BEFORE", "AFTER", "swallow_release"})
    public static final class RequestType
    extends Enum<RequestType> {
        public static final /* enum */ RequestType INITIAL;
        public static final /* enum */ RequestType BEFORE;
        public static final /* enum */ RequestType AFTER;
        private static final /* synthetic */ RequestType[] $VALUES;

        static {
            RequestType[] requestTypeArray = new RequestType[3];
            RequestType[] requestTypeArray2 = requestTypeArray;
            requestTypeArray[0] = INITIAL = new RequestType();
            requestTypeArray[1] = BEFORE = new RequestType();
            requestTypeArray[2] = AFTER = new RequestType();
            $VALUES = requestTypeArray;
        }

        public static RequestType[] values() {
            return (RequestType[])$VALUES.clone();
        }

        public static RequestType valueOf(String string2) {
            return Enum.valueOf(RequestType.class, string2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestQueue;", "", "mRequestType", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;", "(Lcom/swallow/sdk/ext/paging/PagingRequestHelper;Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;)V", "mFailed", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestWrapper;", "getMFailed", "()Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestWrapper;", "setMFailed", "(Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestWrapper;)V", "mLastError", "", "getMLastError", "()Ljava/lang/Throwable;", "setMLastError", "(Ljava/lang/Throwable;)V", "getMRequestType", "()Lcom/swallow/sdk/ext/paging/PagingRequestHelper$RequestType;", "mRunning", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request;", "getMRunning", "()Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request;", "setMRunning", "(Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Request;)V", "mStatus", "Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;", "getMStatus", "()Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;", "setMStatus", "(Lcom/swallow/sdk/ext/paging/PagingRequestHelper$Status;)V", "swallow_release"})
    public final class RequestQueue {
        @Nullable
        private RequestWrapper mFailed;
        @Nullable
        private Request mRunning;
        @Nullable
        private Throwable mLastError;
        @NotNull
        private Status mStatus;
        @NotNull
        private final RequestType mRequestType;

        @Nullable
        public final RequestWrapper getMFailed() {
            return this.mFailed;
        }

        public final void setMFailed(@Nullable RequestWrapper requestWrapper) {
            this.mFailed = requestWrapper;
        }

        @Nullable
        public final Request getMRunning() {
            return this.mRunning;
        }

        public final void setMRunning(@Nullable Request request) {
            this.mRunning = request;
        }

        @Nullable
        public final Throwable getMLastError() {
            return this.mLastError;
        }

        public final void setMLastError(@Nullable Throwable throwable) {
            this.mLastError = throwable;
        }

        @NotNull
        public final Status getMStatus() {
            return this.mStatus;
        }

        public final void setMStatus(@NotNull Status status) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"<set-?>");
            this.mStatus = status;
        }

        @NotNull
        public final RequestType getMRequestType() {
            return this.mRequestType;
        }

        public RequestQueue(RequestType mRequestType) {
            Intrinsics.checkNotNullParameter((Object)((Object)mRequestType), (String)"mRequestType");
            this.mRequestType = mRequestType;
            this.mStatus = Status.SUCCESS;
        }
    }
}

