/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/swallow/fly/utils/ZipHelper;", "", "()V", "Companion", "swallow_release"})
public final class ZipHelper {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\bJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\bJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n\u00a8\u0006\u0014"}, d2={"Lcom/swallow/fly/utils/ZipHelper$Companion;", "", "()V", "closeQuietly", "", "closeable", "Ljava/io/Closeable;", "compressForGzip", "", "string", "", "compressForZlib", "bytesToCompress", "stringToCompress", "decompressForGzip", "compressed", "charsetName", "decompressForZlib", "bytesToDecompress", "decompressToStringForZlib", "swallow_release"})
    public static final class Companion {
        @Nullable
        public final String decompressToStringForZlib(@NotNull byte[] bytesToDecompress) {
            Intrinsics.checkNotNullParameter((Object)bytesToDecompress, (String)"bytesToDecompress");
            return this.decompressToStringForZlib(bytesToDecompress, "UTF-8");
        }

        @Nullable
        public final String decompressToStringForZlib(@NotNull byte[] bytesToDecompress, @NotNull String charsetName) {
            Intrinsics.checkNotNullParameter((Object)bytesToDecompress, (String)"bytesToDecompress");
            Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
            byte[] bytesDecompressed = this.decompressForZlib(bytesToDecompress);
            String returnValue = null;
            try {
                String string2;
                if (bytesDecompressed != null) {
                    byte[] byArray = bytesDecompressed;
                    boolean bl = false;
                    boolean bl2 = false;
                    byte[] it = byArray;
                    boolean bl3 = false;
                    int n = 0;
                    int n2 = bytesDecompressed.length;
                    Charset charset = Charset.forName(charsetName);
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
                    Charset charset2 = charset;
                    boolean bl4 = false;
                    string2 = new String(it, n, n2, charset2);
                } else {
                    string2 = null;
                }
                returnValue = string2;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
            return returnValue;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final byte[] decompressForZlib(@NotNull byte[] bytesToDecompress) {
            Intrinsics.checkNotNullParameter((Object)bytesToDecompress, (String)"bytesToDecompress");
            byte[] returnValues = null;
            Inflater inflater = new Inflater();
            int numberOfBytesToDecompress = bytesToDecompress.length;
            inflater.setInput(bytesToDecompress, 0, numberOfBytesToDecompress);
            int numberOfBytesDecompressedSoFar = 0;
            List bytesDecompressedSoFar = new ArrayList();
            try {
                while (!inflater.needsInput()) {
                    byte[] bytesDecompressedBuffer = new byte[numberOfBytesToDecompress];
                    int numberOfBytesDecompressedThisTime = inflater.inflate(bytesDecompressedBuffer);
                    numberOfBytesDecompressedSoFar += numberOfBytesDecompressedThisTime;
                    int n = 0;
                    int n2 = numberOfBytesDecompressedThisTime;
                    while (n < n2) {
                        void b;
                        bytesDecompressedSoFar.add(bytesDecompressedBuffer[b]);
                        ++b;
                    }
                }
                returnValues = new byte[bytesDecompressedSoFar.size()];
                int bytesDecompressedBuffer = 0;
                int n = returnValues.length;
                while (bytesDecompressedBuffer < n) {
                    void b;
                    returnValues[b] = ((Number)bytesDecompressedSoFar.get((int)b)).byteValue();
                    ++b;
                }
            }
            catch (DataFormatException dfe) {
                dfe.printStackTrace();
            }
            inflater.end();
            return returnValues;
        }

        @Nullable
        public final byte[] compressForZlib(@Nullable byte[] bytesToCompress) {
            Deflater deflater = new Deflater();
            deflater.setInput(bytesToCompress);
            deflater.finish();
            byte[] bytesCompressed = new byte[Short.MAX_VALUE];
            int numberOfBytesAfterCompression = deflater.deflate(bytesCompressed);
            byte[] returnValues = new byte[numberOfBytesAfterCompression];
            System.arraycopy(bytesCompressed, 0, returnValues, 0, numberOfBytesAfterCompression);
            return returnValues;
        }

        @Nullable
        public final byte[] compressForZlib(@NotNull String stringToCompress) {
            Intrinsics.checkNotNullParameter((Object)stringToCompress, (String)"stringToCompress");
            byte[] returnValues = null;
            try {
                String string2 = stringToCompress;
                Object object = "UTF-8";
                boolean bl = false;
                Charset charset = Charset.forName((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
                object = charset;
                bl = false;
                byte[] byArray = string2.getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                returnValues = this.compressForZlib(byArray);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
            return returnValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final byte[] compressForGzip(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
            ByteArrayOutputStream os = null;
            GZIPOutputStream gos = null;
            try {
                os = new ByteArrayOutputStream(string2.length());
                gos = new GZIPOutputStream(os);
                Object object = string2;
                Object object2 = "UTF-8";
                boolean bl = false;
                Charset charset = Charset.forName((String)object2);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
                object2 = charset;
                bl = false;
                byte[] byArray = ((String)object).getBytes((Charset)object2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                gos.write(byArray);
                object = os.toByteArray();
                return object;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.closeQuietly(gos);
                this.closeQuietly(os);
            }
            return null;
        }

        @Nullable
        public final String decompressForGzip(@NotNull byte[] compressed) {
            Intrinsics.checkNotNullParameter((Object)compressed, (String)"compressed");
            return this.decompressForGzip(compressed, "UTF-8");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final String decompressForGzip(@NotNull byte[] compressed, @NotNull String charsetName) {
            Intrinsics.checkNotNullParameter((Object)compressed, (String)"compressed");
            Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
            int BUFFER_SIZE = compressed.length;
            GZIPInputStream gis = null;
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(compressed);
                gis = new GZIPInputStream((InputStream)is, BUFFER_SIZE);
                StringBuilder string2 = new StringBuilder();
                byte[] data = new byte[BUFFER_SIZE];
                int bytesRead = 0;
                while (true) {
                    Charset charset;
                    int n = gis.read(data);
                    int n2 = 0;
                    boolean bl = false;
                    int it = n;
                    boolean bl2 = false;
                    bytesRead = it;
                    if (n == -1) break;
                    n = 0;
                    n2 = bytesRead;
                    Intrinsics.checkNotNullExpressionValue((Object)Charset.forName(charsetName), (String)"Charset.forName(charsetName)");
                    boolean bl3 = false;
                    string2.append(new String(data, n, n2, charset));
                }
                String string3 = string2.toString();
                return string3;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.closeQuietly(gis);
                this.closeQuietly(is);
            }
            return null;
        }

        public final void closeQuietly(@Nullable Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (RuntimeException rethrown) {
                    throw (Throwable)rethrown;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

