/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.utils;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.FileProvider;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u0016\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0004J\u0016\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017J\u001e\u0010,\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004J\u001e\u0010/\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00100\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0017J\u000e\u00101\u001a\u00020!2\u0006\u0010'\u001a\u00020(J\u000e\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020(J\u000e\u00104\u001a\u00020!2\u0006\u0010'\u001a\u00020(J\u000e\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020\u0004J\u0016\u00107\u001a\u0002082\u0006\u0010'\u001a\u00020(2\u0006\u00109\u001a\u00020&J\u000e\u0010:\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(J\u0016\u0010;\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0004J9\u0010<\u001a\u0004\u0018\u00010\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010=\u001a\u0002082\b\u0010>\u001a\u0004\u0018\u00010\u00042\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010@H\u0007\u00a2\u0006\u0002\u0010AJ\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00040C2\u0006\u0010D\u001a\u00020\u0004J\u0010\u0010E\u001a\u00020\u00042\b\u0010F\u001a\u0004\u0018\u00010\u0004J\u000e\u0010G\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(J\u001a\u0010H\u001a\u0004\u0018\u00010\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010=\u001a\u000208H\u0007J\u0016\u0010I\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00109\u001a\u00020&J\u000e\u0010J\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(J\u000e\u0010K\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(J\u0012\u0010L\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u00010\u0004J\u0018\u0010M\u001a\u0004\u0018\u0001082\u0006\u0010'\u001a\u00020(2\u0006\u00106\u001a\u00020\u0004J\u0018\u0010N\u001a\u0004\u0018\u00010&2\u0006\u00109\u001a\u00020&2\u0006\u0010O\u001a\u00020PJ\u0010\u0010Q\u001a\u00020R2\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010S\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u0004J\u000e\u0010T\u001a\u00020R2\u0006\u0010=\u001a\u000208J\u000e\u0010U\u001a\u00020R2\u0006\u0010=\u001a\u000208J\u000e\u0010V\u001a\u00020R2\u0006\u0010=\u001a\u000208J\u000e\u0010W\u001a\u00020R2\u0006\u0010=\u001a\u000208J\u000e\u0010X\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u0004J\u0016\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\u00172\u0006\u0010\\\u001a\u00020ZJ\u0016\u0010]\u001a\u00020!2\u0006\u0010\\\u001a\u00020Z2\u0006\u00109\u001a\u00020&J\u000e\u0010^\u001a\u00020Z2\u0006\u0010\\\u001a\u00020ZR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u000e\u0010\u0015\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u0011\u0010\u001c\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0006R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/swallow/fly/utils/FileUtils;", "", "()V", "APP_DIR", "", "getAPP_DIR", "()Ljava/lang/String;", "AUDIO_SUFFIX", "getAUDIO_SUFFIX", "CAMERA_AUDIO_PATH", "getCAMERA_AUDIO_PATH", "CAMERA_PATH", "getCAMERA_PATH", "CROP_PATH", "getCROP_PATH", "Cache_PATH", "getCache_PATH", "DEFAULT_CACHE_DIR", "EXTERNAL_STORAGE_PERMISSION", "IMAGE_SUFFIX", "getIMAGE_SUFFIX", "TAG", "TYPE_AUDIO", "", "TYPE_IMAGE", "TYPE_VIDEO", "VIDEO_SUFFIX", "getVIDEO_SUFFIX", "dcimCameraPath", "getDcimCameraPath", "prefix", "prefixN", "copyAudioFile", "", "pathFrom", "pathTo", "copyFile", "createCameraFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "type", "outputCameraPath", "createCropFile", "createDir", "filename", "directory_path", "createMediaFile", "parentPath", "deleteAllCacheDirFile", "deleteCacheDirFile", "mContext", "deleteCompressCache", "deleteFile", "path", "getAlbumMediaUri", "Landroid/net/Uri;", "file", "getCompressPicPath", "getCompressVideoFile", "getDataColumn", "uri", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getDirFiles", "", "dir", "getFileType", "paramString", "getMediaSavePath", "getPath", "getPhotoCacheDir", "getPicSavePath", "getPictureSavePath", "getPrefixPath", "getVideoContentUri", "getVideoGalleryFile", "fileDescriptor", "Landroid/os/ParcelFileDescriptor;", "hasExternalStoragePermission", "", "isDamage", "isDownloadsDocument", "isExternalStorageDocument", "isGooglePhotosUri", "isMediaDocument", "readPictureDegree", "rotaingImageView", "Landroid/graphics/Bitmap;", "angle", "bitmap", "saveBitmapFile", "toRoundBitmap", "swallow_release"})
public final class FileUtils {
    @NotNull
    public static final String TAG = "FileUtils";
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    public static final int TYPE_AUDIO = 101;
    public static final int TYPE_IMAGE = 102;
    public static final int TYPE_VIDEO = 103;
    private static final String prefix = "file://";
    private static final String prefixN = "content://";
    @NotNull
    private static final String IMAGE_SUFFIX;
    @NotNull
    private static final String VIDEO_SUFFIX;
    @NotNull
    private static final String AUDIO_SUFFIX;
    @NotNull
    private static final String APP_DIR;
    @NotNull
    private static final String CAMERA_PATH;
    @NotNull
    private static final String CAMERA_AUDIO_PATH;
    @NotNull
    private static final String CROP_PATH;
    @NotNull
    private static final String Cache_PATH;
    private static final String DEFAULT_CACHE_DIR = "picture_cache";
    public static final FileUtils INSTANCE;

    @NotNull
    public final String getIMAGE_SUFFIX() {
        return IMAGE_SUFFIX;
    }

    @NotNull
    public final String getVIDEO_SUFFIX() {
        return VIDEO_SUFFIX;
    }

    @NotNull
    public final String getAUDIO_SUFFIX() {
        return AUDIO_SUFFIX;
    }

    @NotNull
    public final String getAPP_DIR() {
        return APP_DIR;
    }

    @NotNull
    public final String getCAMERA_PATH() {
        return CAMERA_PATH;
    }

    @NotNull
    public final String getCAMERA_AUDIO_PATH() {
        return CAMERA_AUDIO_PATH;
    }

    @NotNull
    public final String getCROP_PATH() {
        return CROP_PATH;
    }

    @NotNull
    public final String getCache_PATH() {
        return Cache_PATH;
    }

    @Nullable
    public final String getPrefixPath(@Nullable String path) {
        String path2 = path;
        if (path2 == null) {
            path2 = "";
        }
        if (StringsKt.startsWith$default((String)path2, (String)prefix, (boolean)false, (int)2, null)) {
            return path2;
        }
        if (StringsKt.startsWith$default((String)path2, (String)prefixN, (boolean)false, (int)2, null)) {
            return path2;
        }
        path2 = prefix + path2;
        return path2;
    }

    @NotNull
    public final String getPicSavePath(@NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File appCacheDir = null;
        if (Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState()) && this.hasExternalStoragePermission(context)) {
            File file = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
            appCacheDir = new File(file != null ? file.getAbsolutePath() : null, "Pic");
        }
        if (appCacheDir == null || !appCacheDir.exists() && !appCacheDir.mkdirs()) {
            appCacheDir = context.getCacheDir();
        }
        if ((object = appCacheDir) == null || (object = ((File)object).getPath()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getMediaSavePath(@NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File appCacheDir = null;
        if (Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState()) && this.hasExternalStoragePermission(context)) {
            File file = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            appCacheDir = new File(file != null ? file.getAbsolutePath() : null, "Media");
        }
        if (appCacheDir == null || !appCacheDir.exists() && !appCacheDir.mkdirs()) {
            appCacheDir = context.getCacheDir();
        }
        if ((object = appCacheDir) == null || (object = ((File)object).getPath()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public final Uri getVideoContentUri(@NotNull Context context, @NotNull String path) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Cursor cursor = context.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{path}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = Uri.parse((String)"content://media/external/video/media");
            uri = Uri.withAppendedPath((Uri)baseUri, (String)("" + id));
        } else if (new File(path).exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", path);
            uri = context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, values);
        } else {
            uri = null;
        }
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final File getVideoGalleryFile(@NotNull File file, @NotNull ParcelFileDescriptor fileDescriptor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileDescriptor, (String)"fileDescriptor");
        try {
            FileOutputStream fos = new FileOutputStream(file);
            FileInputStream fis = new FileInputStream(fileDescriptor.getFileDescriptor());
            byte[] buffer = new byte[1024];
            int byteRead = 0;
            while (true) {
                void it;
                int n = fis.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int n2 = n;
                int n3 = -1;
                boolean bl3 = false;
                byteRead = it;
                Unit unit = Unit.INSTANCE;
                if (n3 == n) break;
                fos.write(buffer, 0, byteRead);
            }
            fis.close();
            fos.flush();
            fos.close();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public final Uri getAlbumMediaUri(@NotNull Context context, @NotNull File file) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Uri uri2 = null;
        if (Build.VERSION.SDK_INT >= 24) {
            String packageName = context.getPackageName() + ".fileprovider";
            Uri uri3 = FileProvider.getUriForFile((Context)context.getApplicationContext(), (String)packageName, (File)file);
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"FileProvider.getUriForFi\u2026ntext, packageName, file)");
        } else {
            Uri uri4 = Uri.fromFile((File)file);
            uri = uri4;
            Intrinsics.checkNotNullExpressionValue((Object)uri4, (String)"Uri.fromFile(file)");
        }
        uri2 = uri;
        return uri2;
    }

    @NotNull
    public final String getPictureSavePath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getPicSavePath(context) + '/' + System.currentTimeMillis() + ".png";
    }

    private final boolean hasExternalStoragePermission(Context context) {
        int perm = context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION);
        return perm == 0;
    }

    @NotNull
    public final String getFileType(@Nullable String paramString) {
        String str = "";
        CharSequence charSequence = paramString;
        boolean bl = false;
        int n = 0;
        if (charSequence == null || charSequence.length() == 0) {
            Log.e((String)"tag", (String)"paramString---->null");
            return str;
        }
        Log.e((String)"tag", (String)("paramString:" + paramString));
        int i = StringsKt.lastIndexOf$default((CharSequence)paramString, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (i <= -1) {
            Log.e((String)"tag", (String)"i <= -1");
            return str;
        }
        String string = paramString;
        n = i + 1;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        str = string3;
        Log.e((String)"tag", (String)("paramString.substring(i + 1)------>" + str));
        return str;
    }

    @NotNull
    public final File createCameraFile(@NotNull Context context, int type, @NotNull String outputCameraPath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)outputCameraPath, (String)"outputCameraPath");
        String path = null;
        path = type == 101 ? (!TextUtils.isEmpty((CharSequence)outputCameraPath) ? outputCameraPath : CAMERA_AUDIO_PATH) : (!TextUtils.isEmpty((CharSequence)outputCameraPath) ? outputCameraPath : CAMERA_PATH);
        return type == 101 ? this.createMediaFile(context, path, type) : this.createMediaFile(context, path, type);
    }

    @NotNull
    public final File createCropFile(@NotNull Context context, int type) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.createMediaFile(context, CROP_PATH, type);
    }

    @NotNull
    public final File createMediaFile(@NotNull Context context, @NotNull String parentPath, int type) {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        File appCacheDir = null;
        if (Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState()) && this.hasExternalStoragePermission(context)) {
            File file2 = context.getExternalFilesDir(Environment.DIRECTORY_DCIM);
            appCacheDir = new File(file2 != null ? file2.getAbsolutePath() : null, parentPath);
        }
        if (appCacheDir == null || !appCacheDir.exists() && !appCacheDir.mkdirs()) {
            appCacheDir = context.getCacheDir();
        }
        switch (type) {
            case 102: {
                file = new File(appCacheDir, String.valueOf(System.currentTimeMillis()) + IMAGE_SUFFIX);
                break;
            }
            case 103: {
                file = new File(appCacheDir, String.valueOf(System.currentTimeMillis()) + VIDEO_SUFFIX);
                break;
            }
            case 101: {
                file = new File(appCacheDir, String.valueOf(System.currentTimeMillis()) + AUDIO_SUFFIX);
                break;
            }
            default: {
                file = new File(appCacheDir, String.valueOf(System.currentTimeMillis()) + IMAGE_SUFFIX);
            }
        }
        return file;
    }

    public final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    public final boolean isDownloadsDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    public final boolean isMediaDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    public final boolean isGooglePhotosUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"LogNotTimber"})
    @Nullable
    public final String getDataColumn(@NotNull Context context, @NotNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{column};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow(column);
                String string = cursor.getString(column_index);
                cursor.close();
                return string;
            }
            if (cursor == null) return null;
        }
        catch (IllegalArgumentException ex) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.getDefault();
            String string = "getDataColumn: _data - [%s]";
            Object[] objectArray = new Object[]{ex.getMessage()};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            Log.i((String)TAG, (String)string2);
            return null;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        cursor.close();
        return null;
    }

    @NotNull
    public final File getPhotoCacheDir(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File cacheDir = context.getCacheDir();
        String file_name = file.getName();
        if (cacheDir != null) {
            File file2;
            File mCacheDir = new File(cacheDir, DEFAULT_CACHE_DIR);
            if (!(mCacheDir.mkdirs() || mCacheDir.exists() && mCacheDir.isDirectory())) {
                file2 = file;
            } else {
                String string = file_name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file_name");
                String fileName = StringsKt.endsWith$default((String)string, (String)".webp", (boolean)false, (int)2, null) ? String.valueOf(System.currentTimeMillis()) + ".webp" : String.valueOf(System.currentTimeMillis()) + ".png";
                file2 = new File(mCacheDir, fileName);
            }
            return file2;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return file;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public final String getPath(@NotNull Context context, @NotNull Uri uri) {
        boolean isKitKat;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                List list;
                String docId;
                String string = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                CharSequence charSequence = string;
                String string2 = ":";
                int n = 0;
                string2 = new Regex(string2);
                n = 0;
                boolean bl2 = false;
                List $this$dropLastWhile$iv = string2.split(charSequence, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl3 = false;
                        CharSequence charSequence2 = it;
                        boolean bl4 = false;
                        if (charSequence2.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                    return Environment.getExternalStorageDirectory().toString() + "/" + split[1];
                }
            } else {
                if (this.isDownloadsDocument(uri)) {
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                    Long l = Long.valueOf(id);
                    Intrinsics.checkNotNull((Object)l);
                    Uri uri3 = ContentUris.withAppendedId((Uri)uri2, (long)l);
                    Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"ContentUris.withAppended\u2026f(id)!!\n                )");
                    Uri contentUri = uri3;
                    return this.getDataColumn(context, contentUri, null, null);
                }
                if (this.isMediaDocument(uri)) {
                    Uri uri4;
                    List list;
                    String docId;
                    String string = docId = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                    CharSequence type = string;
                    String $i$f$toTypedArray = ":";
                    int thisCollection$iv = 0;
                    $i$f$toTypedArray = new Regex($i$f$toTypedArray);
                    thisCollection$iv = 0;
                    boolean it = false;
                    List $this$dropLastWhile$iv = $i$f$toTypedArray.split(type, thisCollection$iv);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it2 = (String)iterator$iv.previous();
                            boolean bl5 = false;
                            CharSequence charSequence = it2;
                            boolean bl6 = false;
                            if (charSequence.length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    Collection $this$toTypedArray$iv = list;
                    boolean $i$f$toTypedArray2 = false;
                    Object thisCollection$iv2 = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv2.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] split = stringArray;
                    type = split[0];
                    Uri contentUri = null;
                    switch (type) {
                        case "image": {
                            Uri uri5 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                            uri4 = uri5;
                            Intrinsics.checkNotNullExpressionValue((Object)uri5, (String)"MediaStore.Images.Media.EXTERNAL_CONTENT_URI");
                            break;
                        }
                        case "video": {
                            Uri uri6 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                            uri4 = uri6;
                            Intrinsics.checkNotNullExpressionValue((Object)uri6, (String)"MediaStore.Video.Media.EXTERNAL_CONTENT_URI");
                            break;
                        }
                        case "audio": {
                            Uri uri7 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                            uri4 = uri7;
                            Intrinsics.checkNotNullExpressionValue((Object)uri7, (String)"MediaStore.Audio.Media.EXTERNAL_CONTENT_URI");
                            break;
                        }
                        default: {
                            Uri uri8 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                            uri4 = uri8;
                            Intrinsics.checkNotNullExpressionValue((Object)uri8, (String)"MediaStore.Images.Media.EXTERNAL_CONTENT_URI");
                        }
                    }
                    contentUri = uri4;
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return this.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
                if (this.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return this.getDataColumn(context, uri, null, null);
            }
            if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyFile(@NotNull String pathFrom, @NotNull String pathTo) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pathFrom, (String)"pathFrom");
        Intrinsics.checkNotNullParameter((Object)pathTo, (String)"pathTo");
        if (StringsKt.equals((String)pathFrom, (String)pathTo, (boolean)true)) {
            return;
        }
        FileChannel outputChannel = null;
        FileChannel inputChannel = null;
        try {
            inputChannel = new FileInputStream(new File(pathFrom)).getChannel();
            outputChannel = new FileOutputStream(new File(pathTo)).getChannel();
            FileChannel fileChannel = inputChannel;
            Intrinsics.checkNotNull((Object)fileChannel);
            fileChannel.transferTo(0L, inputChannel.size(), outputChannel);
            inputChannel.close();
        }
        catch (Throwable throwable) {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
            throw throwable;
        }
        inputChannel.close();
        if (outputChannel != null) {
            outputChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyAudioFile(@NotNull String pathFrom, @NotNull String pathTo) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pathFrom, (String)"pathFrom");
        Intrinsics.checkNotNullParameter((Object)pathTo, (String)"pathTo");
        if (StringsKt.equals((String)pathFrom, (String)pathTo, (boolean)true)) {
            return;
        }
        FileChannel outputChannel = null;
        FileChannel inputChannel = null;
        try {
            inputChannel = new FileInputStream(new File(pathFrom)).getChannel();
            outputChannel = new FileOutputStream(new File(pathTo)).getChannel();
            FileChannel fileChannel = inputChannel;
            Intrinsics.checkNotNull((Object)fileChannel);
            fileChannel.transferTo(0L, inputChannel.size(), outputChannel);
            inputChannel.close();
        }
        catch (Throwable throwable) {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
            this.deleteFile(pathFrom);
            throw throwable;
        }
        inputChannel.close();
        if (outputChannel != null) {
            outputChannel.close();
        }
        this.deleteFile(pathFrom);
    }

    public final int readPictureDegree(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    @NotNull
    public final Bitmap rotaingImageView(int angle, @NotNull Bitmap bitmap) {
        Bitmap resizedBitmap;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        String string = "angle2=" + angle;
        boolean bl = false;
        System.out.println((Object)string);
        Bitmap bitmap2 = resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"resizedBitmap");
        return bitmap2;
    }

    public final void saveBitmapFile(@NotNull Bitmap bitmap, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final Bitmap toRoundBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float roundPx = 0.0f;
        float left = 0.0f;
        float top = 0.0f;
        float right = 0.0f;
        float bottom = 0.0f;
        float dst_left = 0.0f;
        float dst_top = 0.0f;
        float dst_right = 0.0f;
        float dst_bottom = 0.0f;
        if (width <= height) {
            roundPx = width / 2;
            left = 0.0f;
            top = 0.0f;
            right = width;
            bottom = width;
            height = width;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = width;
            dst_bottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = height;
            dst_bottom = height;
        }
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dst_left, (int)dst_top, (int)dst_right, (int)dst_bottom);
        RectF rectF = new RectF(dst);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, src, dst, paint);
        Bitmap bitmap2 = output;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"output");
        return bitmap2;
    }

    @NotNull
    public final String createDir(@NotNull Context context, @NotNull String filename, @NotNull String directory_path) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)directory_path, (String)"directory_path");
        String state = Environment.getExternalStorageState();
        File rootDir = Intrinsics.areEqual((Object)state, (Object)"mounted") ? Environment.getExternalStorageDirectory() : context.getCacheDir();
        File path = null;
        if (!TextUtils.isEmpty((CharSequence)directory_path)) {
            StringBuilder stringBuilder = new StringBuilder();
            File file = rootDir;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
            path = new File(stringBuilder.append(file.getAbsolutePath()).append(directory_path).toString());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            File file = rootDir;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
            path = new File(stringBuilder.append(file.getAbsolutePath()).append("/Phoenix").toString());
        }
        if (!path.exists()) {
            path.mkdirs();
        }
        return path.toString() + "/" + filename;
    }

    public final int isDamage(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BitmapFactory.Options options = null;
        options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        if (options.mCancel || options.outWidth == -1 || options.outHeight == -1) {
            return -1;
        }
        return 0;
    }

    @NotNull
    public final List<String> getDirFiles(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        File scanner5Directory = new File(dir);
        ArrayList<String> list = new ArrayList<String>();
        if (scanner5Directory.isDirectory()) {
            File[] fileArray = scanner5Directory.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                String path;
                File file;
                File file2 = file = fileArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                String string = path = file2.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                if (!StringsKt.endsWith$default((String)string, (String)".jpg", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".jpeg", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".png", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".gif", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".webp", (boolean)false, (int)2, null)) continue;
                list.add(path);
            }
        }
        return list;
    }

    @NotNull
    public final String getDcimCameraPath() {
        String absolutePath = null;
        try {
            StringBuilder stringBuilder = new StringBuilder().append("%");
            File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Environment.getExternalS\u2026vironment.DIRECTORY_DCIM)");
            absolutePath = stringBuilder.append(file.getAbsolutePath()).append("/Camera").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return absolutePath;
    }

    public final void deleteCacheDirFile(@NotNull Context mContext) {
        File file;
        int n;
        int n2;
        File[] fileArray;
        File[] files;
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        File cutDir = mContext.getCacheDir();
        File compressDir = new File(mContext.getCacheDir().toString() + "/picture_cache");
        File lubanDir = new File(mContext.getCacheDir().toString() + "/luban_disk_cache");
        if (cutDir != null) {
            fileArray = files = cutDir.listFiles();
            n2 = fileArray.length;
            for (n = 0; n < n2; ++n) {
                File file2 = file = fileArray[n];
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                if (!file2.isFile()) continue;
                file.delete();
            }
        }
        if ((files = compressDir.listFiles()) != null) {
            fileArray = files;
            n2 = fileArray.length;
            for (n = 0; n < n2; ++n) {
                File file3 = file = fileArray[n];
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file");
                if (!file3.isFile()) continue;
                file.delete();
            }
        }
        if ((files = lubanDir.listFiles()) != null) {
            fileArray = files;
            n2 = fileArray.length;
            for (n = 0; n < n2; ++n) {
                File file4 = file = fileArray[n];
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"file");
                if (!file4.isFile()) continue;
                file.delete();
            }
        }
        Log.i((String)TAG, (String)"Cache delete success!");
    }

    public final void deleteFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void deleteAllCacheDirFile(@NotNull Context context) {
        File[] files;
        File dirMusic;
        File[] files2;
        File dirMovies;
        int n;
        File[] files3;
        File dirDic;
        int n2;
        File[] files4;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File dirPictures = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (dirPictures != null && (files4 = dirPictures.listFiles()) != null) {
            File[] fileArray = files4;
            n2 = fileArray.length;
            for (int i = 0; i < n2; ++i) {
                File file;
                File file2 = file = fileArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                if (!file2.isFile()) continue;
                file.delete();
            }
        }
        if ((dirDic = context.getExternalFilesDir(Environment.DIRECTORY_DCIM)) != null && (files3 = dirDic.listFiles()) != null) {
            File[] fileArray = files3;
            n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file;
                File file3 = file = fileArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file");
                if (!file3.isFile()) continue;
                file.delete();
            }
        }
        if ((dirMovies = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES)) != null && (files2 = dirMovies.listFiles()) != null) {
            File[] fileArray = files2;
            int n3 = fileArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                File file;
                File file4 = file = fileArray[n2];
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"file");
                if (!file4.isFile()) continue;
                file.delete();
            }
        }
        if ((dirMusic = context.getExternalFilesDir(Environment.DIRECTORY_MUSIC)) != null && (files = dirMusic.listFiles()) != null) {
            File[] fileArray = files;
            int n4 = fileArray.length;
            for (n = 0; n < n4; ++n) {
                File file;
                File file5 = file = fileArray[n];
                Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"file");
                if (!file5.isFile()) continue;
                file.delete();
            }
        }
    }

    @NotNull
    public final String getCompressPicPath(@NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File appCacheDir = null;
        if (Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState()) && this.hasExternalStoragePermission(context)) {
            File file = context.getExternalFilesDir(Environment.DIRECTORY_DCIM);
            appCacheDir = new File(file != null ? file.getAbsolutePath() : null, "CompressCache");
        }
        if (appCacheDir == null || !appCacheDir.exists() && !appCacheDir.mkdirs()) {
            appCacheDir = context.getCacheDir();
        }
        if ((object = appCacheDir) == null || (object = ((File)object).getPath()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getCompressVideoFile(@NotNull Context context, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        File appCacheDir = null;
        if (Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState()) && this.hasExternalStoragePermission(context)) {
            File file = context.getExternalFilesDir(Environment.DIRECTORY_DCIM);
            appCacheDir = new File(file != null ? file.getAbsolutePath() : null, "CompressCache");
        }
        if (appCacheDir == null || !appCacheDir.exists() && !appCacheDir.mkdirs()) {
            appCacheDir = context.getCacheDir();
        }
        String string = new File(appCacheDir, filename + VIDEO_SUFFIX).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(appCacheDir, filena\u2026IDEO_SUFFIX).absolutePath");
        return string;
    }

    public final void deleteCompressCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = context.getExternalFilesDir(Environment.DIRECTORY_DCIM);
        File cacheDir = new File(file != null ? file.getAbsolutePath() : null, "CompressCache");
        File[] files = cacheDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2;
                File file3 = file2 = fileArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file");
                if (!file3.isFile()) continue;
                file2.delete();
            }
        }
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
        IMAGE_SUFFIX = ".png";
        VIDEO_SUFFIX = ".mp4";
        AUDIO_SUFFIX = ".mp3";
        APP_DIR = "AppData";
        CAMERA_PATH = '/' + APP_DIR + "/CameraImage/";
        CAMERA_AUDIO_PATH = '/' + APP_DIR + "/CameraAudio/";
        CROP_PATH = '/' + APP_DIR + "/CropImage/";
        Cache_PATH = '/' + APP_DIR + "/MediaCache/";
    }
}

