/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.utils;

import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0013\u001a\u00020\u0004J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0018J\u001a\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004J\u001a\u0010%\u001a\u00020\u00042\b\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010'\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Lcom/swallow/fly/utils/DateUtils;", "", "()V", "CHINA_DATE_FORMAT", "", "DEFAULT_DATETIME_FORMAT", "DEFAULT_DATE_FORMAT", "DEFAULT_YEAR_MONTH", "PATTERN_E", "PATTERN_N", "firstDayOfNextMonth", "getFirstDayOfNextMonth", "()Ljava/lang/String;", "dateToStamp", "", "dateStr", "getCnDateFromStamp", "timeMill", "getCurrentDate", "getCurrentMonth", "getCurrentTime", "getCurrentTime2", "getDateFormat", "date", "Ljava/util/Date;", "pattern", "getDateFromStamp", "getDateFromStampE", "getDateMillisFromStamp", "getFirstDayofNextMonth", "isMonthLastDay", "", "timer", "isTrueDate", "inputDate", "parseDate", "time", "timeStamp2Date", "seconds", "format", "swallow_release"})
public final class DateUtils {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String CHINA_DATE_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    private static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFAULT_YEAR_MONTH = "yyyy-MM";
    @NotNull
    public static final String PATTERN_E = "yyyy-MM-dd";
    private static final String PATTERN_N = "HH:mm:ss";
    public static final DateUtils INSTANCE;

    public final long dateToStamp(@NotNull String dateStr) {
        Intrinsics.checkNotNullParameter((Object)dateStr, (String)"dateStr");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        try {
            Date date = format.parse(dateStr);
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"format.parse(dateStr)");
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date().getTime();
        }
    }

    @NotNull
    public final String getDateFromStamp(long timeMill) {
        Date d = new Date(timeMill);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        String string2 = format.format(d);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.format(d)");
        return string2;
    }

    @NotNull
    public final String getCnDateFromStamp(long timeMill) {
        Date d = new Date(timeMill);
        SimpleDateFormat format = new SimpleDateFormat(CHINA_DATE_FORMAT, Locale.CHINA);
        String string2 = format.format(d);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.format(d)");
        return string2;
    }

    @NotNull
    public final String getDateMillisFromStamp(long timeMill) {
        Date d = new Date(timeMill);
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT, Locale.CHINA);
        String string2 = format.format(d);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.format(d)");
        return string2;
    }

    public final boolean isMonthLastDay(long timer) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"calendar");
        calendar2.setTime(new Date(timer));
        calendar.set(5, calendar.get(5) + 1);
        return calendar.get(5) == 1;
    }

    @NotNull
    public final String getCurrentMonth() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_YEAR_MONTH);
        Calendar calendar = now;
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"now");
        String string2 = sdf.format(calendar.getTimeInMillis());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdf.format(now.timeInMillis)");
        return string2;
    }

    @Nullable
    public final String getCurrentDate() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = now;
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"now");
        return sdf.format(calendar.getTimeInMillis());
    }

    @Nullable
    public final String getCurrentTime() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_N);
        Calendar calendar = now;
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"now");
        return sdf.format(calendar.getTimeInMillis());
    }

    @Nullable
    public final String getCurrentTime2() {
        Date currentDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT);
        return sdf.format(currentDate);
    }

    public final long parseDate(@Nullable String time, @Nullable String pattern) {
        long l;
        try {
            long l2;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            if (TextUtils.isEmpty((CharSequence)time)) {
                l2 = System.currentTimeMillis();
            } else {
                Date date = simpleDateFormat.parse(time);
                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"simpleDateFormat.parse(time)");
                l2 = date.getTime();
            }
            l = l2;
        }
        catch (ParseException e) {
            e.printStackTrace();
            l = System.currentTimeMillis();
        }
        return l;
    }

    public final boolean isTrueDate(@NotNull Date inputDate) {
        Calendar instance;
        Intrinsics.checkNotNullParameter((Object)inputDate, (String)"inputDate");
        Calendar calendar = instance = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"instance");
        Date currTime = calendar.getTime();
        long l = inputDate.getTime();
        Date date = currTime;
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"currTime");
        return l <= date.getTime();
    }

    @NotNull
    public final String timeStamp2Date(@Nullable String seconds, @Nullable String format) {
        String format2;
        block7: {
            block6: {
                boolean bl;
                CharSequence charSequence;
                block5: {
                    block4: {
                        format2 = format;
                        if (seconds == null) break block4;
                        charSequence = seconds;
                        bl = false;
                        if (!(charSequence.length() == 0) && !Intrinsics.areEqual((Object)seconds, (Object)"null")) break block5;
                    }
                    return "";
                }
                if (format2 == null) break block6;
                charSequence = format2;
                bl = false;
                if (!(charSequence.length() == 0)) break block7;
            }
            format2 = DEFAULT_DATETIME_FORMAT;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format2);
        Long l = Long.valueOf(seconds + "000");
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(seconds + \"000\")");
        String string2 = sdf.format(new Date(l));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdf.format(Date(java.lan\u2026alueOf(seconds + \"000\")))");
        return string2;
    }

    @NotNull
    public final String getFirstDayOfNextMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        calendar.set(5, 1);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"calendar");
        return this.getDateFormat(calendar2.getTime(), "yyyy-MM-dd");
    }

    @NotNull
    public final String getFirstDayofNextMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        calendar.set(5, 1);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"calendar");
        return this.getDateFormat(calendar2.getTime(), "yyyy-MM-dd");
    }

    @NotNull
    public final String getDateFromStampE(long timeMill) {
        Date d = new Date(timeMill);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        String string2 = format.format(d);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.format(d)");
        return string2;
    }

    @NotNull
    public final String getDateFormat(@Nullable Date date, @Nullable String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String string2 = sdf.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdf.format(date)");
        return string2;
    }

    private DateUtils() {
    }

    static {
        DateUtils dateUtils;
        INSTANCE = dateUtils = new DateUtils();
    }
}

