/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.http.printer;

import android.text.InputFilter;
import android.text.Spanned;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/swallow/fly/http/printer/CharacterHandler;", "", "()V", "Companion", "swallow_release"})
public final class CharacterHandler {
    @NotNull
    private static final InputFilter emojiFilter;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        emojiFilter = new InputFilter(){
            private Pattern emoji;

            public final Pattern getEmoji() {
                return this.emoji;
            }

            public final void setEmoji(Pattern pattern) {
                this.emoji = pattern;
            }

            @Nullable
            public CharSequence filter(@NotNull CharSequence source, int start, int end, @NotNull Spanned dest, int dstart, int dend) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                Matcher emojiMatcher = this.emoji.matcher(source);
                return emojiMatcher.find() ? (CharSequence)"" : null;
            }
            {
                this.emoji = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 66);
            }
        };
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/swallow/fly/http/printer/CharacterHandler$Companion;", "", "()V", "emojiFilter", "Landroid/text/InputFilter;", "getEmojiFilter", "()Landroid/text/InputFilter;", "jsonFormat", "", "json", "str2HexStr", "str", "xmlFormat", "xml", "swallow_release"})
    public static final class Companion {
        @NotNull
        public final InputFilter getEmojiFilter() {
            return emojiFilter;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String str2HexStr(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String string2 = "0123456789ABCDEF";
            boolean bl = false;
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] chars = cArray;
            StringBuilder sb = new StringBuilder("");
            String string3 = str;
            Charset charset = Charsets.UTF_8;
            int n = 0;
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bs = byArray;
            int bit = 0;
            int n2 = 0;
            n = bs.length;
            while (n2 < n) {
                void i;
                bit = Util.and((byte)bs[i], (int)240) >> 4;
                sb.append(chars[bit]);
                bit = Util.and((byte)bs[i], (int)15);
                sb.append(chars[bit]);
                ++i;
            }
            String string4 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sb.toString()");
            String $this$trim$iv = string4;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }

        @Nullable
        public final String jsonFormat(@Nullable String json) {
            CharSequence charSequence = json;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                return "Empty/Null json content";
            }
            String jsonStr = json;
            String message = null;
            try {
                String string2;
                String $this$trim$iv = jsonStr;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl3 = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (StringsKt.startsWith$default((String)(jsonStr = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"{", (boolean)false, (int)2, null)) {
                    JSONObject jsonObject = new JSONObject(jsonStr);
                    string2 = jsonObject.toString(4);
                } else if (StringsKt.startsWith$default((String)json, (String)"[", (boolean)false, (int)2, null)) {
                    JSONArray jsonArray = new JSONArray(jsonStr);
                    string2 = jsonArray.toString(4);
                } else {
                    string2 = jsonStr;
                }
                message = string2;
            }
            catch (JSONException e) {
                message = jsonStr;
            }
            catch (OutOfMemoryError error) {
                message = "Output omitted because of Object size";
            }
            return message;
        }

        @Nullable
        public final String xmlFormat(@Nullable String xml) {
            String string2;
            CharSequence charSequence = xml;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                return "Empty/Null xml content";
            }
            String message = null;
            try {
                Source xmlInput = new StreamSource(new StringReader(xml));
                StreamResult xmlOutput = new StreamResult(new StringWriter());
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(xmlInput, xmlOutput);
                CharSequence charSequence2 = xmlOutput.getWriter().toString();
                String string3 = ">";
                boolean bl3 = false;
                string3 = new Regex(string3);
                String string4 = ">\n";
                boolean bl4 = false;
                string2 = string3.replaceFirst(charSequence2, string4);
            }
            catch (TransformerException e) {
                string2 = xml;
            }
            message = string2;
            return message;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

