/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.http.printer;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.swallow.fly.http.interceptor.RequestInterceptor;
import com.swallow.fly.http.printer.CharacterHandler;
import com.swallow.fly.http.printer.FormatPrinter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okhttp3.MediaType;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0016JF\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u001c\u0010\u0014\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0015\u001a\u00020\u000fH\u0016JZ\u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/swallow/fly/http/printer/DefaultFormatPrinter;", "Lcom/swallow/fly/http/printer/FormatPrinter;", "()V", "printFileRequest", "", "request", "Lokhttp3/Request;", "printFileResponse", "chainMs", "", "isSuccessful", "", "code", "", "headers", "", "segments", "", "message", "responseUrl", "printJsonRequest", "bodyString", "printJsonResponse", "contentType", "Lokhttp3/MediaType;", "Companion", "swallow_release"})
public final class DefaultFormatPrinter
implements FormatPrinter {
    private static final String TAG = "HttpLog";
    private static final String LINE_SEPARATOR;
    private static final String DOUBLE_SEPARATOR;
    private static final String[] OMITTED_RESPONSE;
    private static final String[] OMITTED_REQUEST;
    private static final String N = "\n";
    private static final String T = "\t";
    private static final String REQUEST_UP_LINE = "   \u250c\u2500\u2500\u2500\u2500\u2500\u2500 Request \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String END_LINE = "   \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String RESPONSE_UP_LINE = "   \u250c\u2500\u2500\u2500\u2500\u2500\u2500 Response \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BODY_TAG = "Body:";
    private static final String URL_TAG = "URL: ";
    private static final String METHOD_TAG = "Method: @";
    private static final String HEADERS_TAG = "Headers:";
    private static final String STATUS_CODE_TAG = "Status Code: ";
    private static final String RECEIVED_TAG = "Received in: ";
    private static final String CORNER_UP = "\u250c ";
    private static final String CORNER_BOTTOM = "\u2514 ";
    private static final String CENTER_LINE = "\u251c ";
    private static final String DEFAULT_LINE = "\u2502 ";
    private static final ThreadLocal<Integer> last;
    private static final String[] ARMS;
    public static final Companion Companion;

    @Override
    public void printJsonRequest(@NonNull @NotNull Request request, @NonNull @NotNull String bodyString) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)bodyString, (String)"bodyString");
        String requestBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + bodyString;
        String tag = DefaultFormatPrinter.Companion.getTag(true);
        Timber.tag((String)tag).d(REQUEST_UP_LINE, new Object[0]);
        Companion.logLines(tag, new String[]{URL_TAG + request.url()}, false);
        Companion.logLines(tag, DefaultFormatPrinter.Companion.getRequest(request), true);
        CharSequence charSequence = requestBody;
        String string2 = LINE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LINE_SEPARATOR");
        String string3 = string2;
        int n = 0;
        string3 = new Regex(string3);
        n = 0;
        boolean bl = false;
        Collection $this$toTypedArray$iv = string3.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Companion.logLines(tag, stringArray, true);
        Log.d((String)tag, (String)END_LINE);
    }

    @Override
    public void printFileRequest(@NonNull @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String tag = DefaultFormatPrinter.Companion.getTag(true);
        Log.d((String)tag, (String)REQUEST_UP_LINE);
        Companion.logLines(tag, new String[]{URL_TAG + request.url()}, false);
        Companion.logLines(tag, DefaultFormatPrinter.Companion.getRequest(request), true);
        Companion.logLines(tag, OMITTED_REQUEST, true);
        Log.d((String)tag, (String)END_LINE);
    }

    @Override
    public void printJsonResponse(long chainMs, boolean isSuccessful, int code, @NotNull String headers, @Nullable MediaType contentType, @Nullable String bodyString, @NotNull List<String> segments, @NotNull String message, @NotNull String responseUrl) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)responseUrl, (String)"responseUrl");
        String bodyString2 = bodyString;
        bodyString2 = RequestInterceptor.Companion.isJson(contentType) ? CharacterHandler.Companion.jsonFormat(bodyString2) : (RequestInterceptor.Companion.isXml(contentType) ? CharacterHandler.Companion.xmlFormat(bodyString2) : bodyString2);
        String responseBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + bodyString2;
        String tag = DefaultFormatPrinter.Companion.getTag(false);
        String[] urlLine = new String[]{URL_TAG + responseUrl, N};
        Log.d((String)tag, (String)RESPONSE_UP_LINE);
        Companion.logLines(tag, urlLine, true);
        Companion.logLines(tag, DefaultFormatPrinter.Companion.getResponse(headers, chainMs, code, isSuccessful, segments, message), true);
        CharSequence charSequence = responseBody;
        String string2 = LINE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LINE_SEPARATOR");
        String string3 = string2;
        int n = 0;
        string3 = new Regex(string3);
        n = 0;
        boolean bl = false;
        Collection $this$toTypedArray$iv = string3.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Companion.logLines(tag, stringArray, true);
        Log.d((String)tag, (String)END_LINE);
    }

    @Override
    public void printFileResponse(long chainMs, boolean isSuccessful, int code, @NotNull String headers, @NotNull List<String> segments, @NotNull String message, @NotNull String responseUrl) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)responseUrl, (String)"responseUrl");
        String tag = DefaultFormatPrinter.Companion.getTag(false);
        String[] urlLine = new String[]{URL_TAG + responseUrl, N};
        Log.d((String)tag, (String)RESPONSE_UP_LINE);
        Companion.logLines(tag, urlLine, true);
        Companion.logLines(tag, DefaultFormatPrinter.Companion.getResponse(headers, chainMs, code, isSuccessful, segments, message), true);
        Companion.logLines(tag, OMITTED_RESPONSE, true);
        Log.d((String)tag, (String)END_LINE);
    }

    static {
        Companion = new Companion(null);
        LINE_SEPARATOR = System.getProperty("line.separator");
        DOUBLE_SEPARATOR = LINE_SEPARATOR + LINE_SEPARATOR;
        OMITTED_RESPONSE = new String[]{LINE_SEPARATOR, "Omitted response body"};
        OMITTED_REQUEST = new String[]{LINE_SEPARATOR, "Omitted request body"};
        last = new ThreadLocal<Integer>(){

            @NotNull
            protected Integer initialValue() {
                return 0;
            }
        };
        ARMS = new String[]{"-A-", "-R-", "-M-", "-S-"};
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002J\u001b\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%JI\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010!\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050-2\u0006\u0010.\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020+H\u0002J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u0005H\u0002J)\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00052\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u00108\u001a\u00020+\u00a2\u0006\u0002\u00109J\u0012\u0010:\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u00020\u0005H\u0002J\u0016\u0010;\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050-H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001e\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/swallow/fly/http/printer/DefaultFormatPrinter$Companion;", "", "()V", "ARMS", "", "", "[Ljava/lang/String;", "BODY_TAG", "CENTER_LINE", "CORNER_BOTTOM", "CORNER_UP", "DEFAULT_LINE", "DOUBLE_SEPARATOR", "END_LINE", "HEADERS_TAG", "LINE_SEPARATOR", "kotlin.jvm.PlatformType", "METHOD_TAG", "N", "OMITTED_REQUEST", "OMITTED_RESPONSE", "RECEIVED_TAG", "REQUEST_UP_LINE", "RESPONSE_UP_LINE", "STATUS_CODE_TAG", "T", "TAG", "URL_TAG", "last", "Ljava/lang/ThreadLocal;", "", "computeKey", "dotHeaders", "header", "getRequest", "request", "Lokhttp3/Request;", "(Lokhttp3/Request;)[Ljava/lang/String;", "getResponse", "tookMs", "", "code", "isSuccessful", "", "segments", "", "message", "(Ljava/lang/String;JIZLjava/util/List;Ljava/lang/String;)[Ljava/lang/String;", "getTag", "isRequest", "isEmpty", "line", "logLines", "", "tag", "lines", "withLineSize", "(Ljava/lang/String;[Ljava/lang/String;Z)V", "resolveTag", "slashSegments", "swallow_release"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEmpty(String line) {
            if (TextUtils.isEmpty((CharSequence)line)) return true;
            if (Intrinsics.areEqual((Object)DefaultFormatPrinter.N, (Object)line)) return true;
            if (Intrinsics.areEqual((Object)DefaultFormatPrinter.T, (Object)line)) return true;
            String $this$trim$iv = line;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!TextUtils.isEmpty((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void logLines(@NotNull String tag, @NotNull String[] lines, boolean withLineSize) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            String[] stringArray = lines;
            int n = stringArray.length;
            block0: for (int i = 0; i < n; ++i) {
                int MAX_LONG_SIZE;
                int n2 = 0;
                String line = stringArray[i];
                int lineLength = line.length();
                int n3 = lineLength / (MAX_LONG_SIZE = withLineSize ? 110 : lineLength);
                if (n2 > n3) continue;
                while (true) {
                    void i2;
                    void start = i2 * MAX_LONG_SIZE;
                    int end = (i2 + true) * MAX_LONG_SIZE;
                    end = end > line.length() ? line.length() : end;
                    String string2 = this.resolveTag(tag);
                    StringBuilder stringBuilder = new StringBuilder().append(DefaultFormatPrinter.DEFAULT_LINE);
                    String string3 = line;
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring((int)start, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Log.d((String)string2, (String)stringBuilder.append(string5).toString());
                    if (i2 == n3) continue block0;
                    ++i2;
                }
            }
        }

        private final String computeKey() {
            if (((Number)last.get()).intValue() >= 4) {
                last.set(0);
            }
            String[] stringArray = ARMS;
            Object t = last.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"last.get()");
            String s = stringArray[((Number)t).intValue()];
            last.set(((Number)last.get()).intValue() + 1);
            return s;
        }

        private final String resolveTag(String tag) {
            return this.computeKey() + tag;
        }

        private final String[] getRequest(Request request) {
            String log = null;
            String header = request.headers().toString();
            log = DefaultFormatPrinter.METHOD_TAG + request.method() + DOUBLE_SEPARATOR + (this.isEmpty(header) ? "" : DefaultFormatPrinter.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(header));
            CharSequence charSequence = log;
            String string2 = LINE_SEPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LINE_SEPARATOR");
            String string3 = string2;
            int n = 0;
            string3 = new Regex(string3);
            n = 0;
            boolean bl = false;
            Collection $this$toTypedArray$iv = string3.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray;
        }

        private final String[] getResponse(String header, long tookMs, int code, boolean isSuccessful, List<String> segments, String message) {
            String log = null;
            String segmentString = this.slashSegments(segments);
            log = (!TextUtils.isEmpty((CharSequence)segmentString) ? segmentString + " - " : "") + "is success : " + isSuccessful + " - " + DefaultFormatPrinter.RECEIVED_TAG + tookMs + "ms" + DOUBLE_SEPARATOR + DefaultFormatPrinter.STATUS_CODE_TAG + code + " / " + message + DOUBLE_SEPARATOR + (this.isEmpty(header) ? "" : DefaultFormatPrinter.HEADERS_TAG + LINE_SEPARATOR + this.dotHeaders(header));
            CharSequence charSequence = log;
            String string2 = LINE_SEPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LINE_SEPARATOR");
            String string3 = string2;
            int n = 0;
            string3 = new Regex(string3);
            n = 0;
            boolean bl = false;
            Collection $this$toTypedArray$iv = string3.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return stringArray;
        }

        private final String slashSegments(List<String> segments) {
            StringBuilder segmentString = new StringBuilder();
            for (String segment : segments) {
                segmentString.append("/").append(segment);
            }
            String string2 = segmentString.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"segmentString.toString()");
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        private final String dotHeaders(String header) {
            CharSequence charSequence = header;
            String string2 = LINE_SEPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LINE_SEPARATOR");
            String string3 = string2;
            int n = 0;
            string3 = new Regex(string3);
            n = 0;
            int n2 = 0;
            Collection $this$toTypedArray$iv = string3.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv2.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] headers = stringArray;
            StringBuilder builder = new StringBuilder();
            String tag = "\u2500 ";
            if (headers.length > 1) {
                int thisCollection$iv2 = 0;
                n2 = headers.length;
                while (thisCollection$iv2 < n2) {
                    void i;
                    tag = i == false ? DefaultFormatPrinter.CORNER_UP : (i == headers.length - 1 ? DefaultFormatPrinter.CORNER_BOTTOM : DefaultFormatPrinter.CENTER_LINE);
                    builder.append(tag).append(headers[i]).append(DefaultFormatPrinter.N);
                    ++i;
                }
            } else {
                for (String item : headers) {
                    builder.append(tag).append(item).append(DefaultFormatPrinter.N);
                }
            }
            String string4 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"builder.toString()");
            return string4;
        }

        private final String getTag(boolean isRequest) {
            return isRequest ? "HttpLog-Request" : "HttpLog-Response";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

