/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.http.interceptor;

import com.swallow.fly.http.interceptor.GlobalHttpHandler;
import com.swallow.fly.http.printer.CharacterHandler;
import com.swallow.fly.http.printer.FormatPrinter;
import com.swallow.fly.utils.UrlEncoderUtils;
import com.swallow.fly.utils.ZipHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Singleton
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0003R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/swallow/fly/http/interceptor/RequestInterceptor;", "Lokhttp3/Interceptor;", "()V", "mHandler", "Lcom/swallow/fly/http/interceptor/GlobalHttpHandler;", "mPrinter", "Lcom/swallow/fly/http/printer/FormatPrinter;", "printLevel", "Lcom/swallow/fly/http/interceptor/RequestInterceptor$Level;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "parseContent", "", "responseBody", "Lokhttp3/ResponseBody;", "encoding", "clone", "Lokio/Buffer;", "parseParams", "request", "Lokhttp3/Request;", "printResult", "response", "logResponse", "", "Companion", "Level", "swallow_release"})
public final class RequestInterceptor
implements Interceptor {
    @Inject
    @JvmField
    @androidx.annotation.Nullable
    @Nullable
    public GlobalHttpHandler mHandler;
    @Inject
    @JvmField
    @androidx.annotation.Nullable
    @Nullable
    public FormatPrinter mPrinter;
    @Inject
    @JvmField
    @NotNull
    public Level printLevel = Level.ALL;
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        block15: {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            request = chain.request();
            v0 = logRequest = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.REQUEST;
            if (!logRequest) break block15;
            if (request.body() == null) ** GOTO lbl-1000
            v1 = request.body();
            Intrinsics.checkNotNull((Object)v1);
            if (RequestInterceptor.Companion.isParseable(v1.contentType())) {
                v2 = this.mPrinter;
                if (v2 != null) {
                    v2.printJsonRequest(request, this.parseParams(request));
                }
            } else lbl-1000:
            // 2 sources

            {
                v3 = this.mPrinter;
                if (v3 != null) {
                    v3.printFileRequest(request);
                }
            }
        }
        logResponse = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.RESPONSE;
        t1 = logResponse != false ? System.nanoTime() : 0L;
        originalResponse = null;
        try {
            var8_7 = chain.proceed(request);
        }
        catch (Exception e) {
            v4 = this.mHandler;
            v5 = response = v4 != null ? v4.redirectRequest(chain, request, e) : null;
            if (response != null) {
                return response;
            }
            Timber.w((String)("Http Error: " + e), (Object[])new Object[0]);
            throw (Throwable)e;
        }
        originalResponse = var8_7;
        t2 = logResponse != false ? System.nanoTime() : 0L;
        responseBody = originalResponse.body();
        bodyString = null;
        if (responseBody != null && RequestInterceptor.Companion.isParseable(responseBody.contentType())) {
            bodyString = this.printResult(request, originalResponse, logResponse);
        }
        if (logResponse) {
            segmentList = request.url().encodedPathSegments();
            header = originalResponse.headers().toString();
            code = originalResponse.code();
            isSuccessful = originalResponse.isSuccessful();
            message = originalResponse.message();
            url = originalResponse.request().url().toString();
            if (responseBody != null && RequestInterceptor.Companion.isParseable(responseBody.contentType())) {
                v6 = this.mPrinter;
                if (v6 != null) {
                    v6.printJsonResponse(TimeUnit.NANOSECONDS.toMillis(t2 - t1), isSuccessful, code, header, responseBody.contentType(), bodyString, segmentList, message, url);
                }
            } else {
                v7 = this.mPrinter;
                if (v7 != null) {
                    v7.printFileResponse(TimeUnit.NANOSECONDS.toMillis(t2 - t1), isSuccessful, code, header, segmentList, message, url);
                }
            }
        }
        if (this.mHandler != null) {
            v8 = this.mHandler;
            Intrinsics.checkNotNull((Object)v8);
            v9 = v8.onHttpResultResponse(bodyString, chain, originalResponse);
        } else {
            v9 = originalResponse;
        }
        return v9;
    }

    @androidx.annotation.Nullable
    private final String printResult(Request request, Response response, boolean logResponse) throws IOException {
        String string2;
        try {
            ResponseBody responseBody;
            ResponseBody responseBody2 = responseBody = response.newBuilder().build().body();
            Intrinsics.checkNotNull((Object)responseBody2);
            BufferedSource source = responseBody2.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            String encoding = response.headers().get("Content-Encoding");
            Buffer clone = buffer.clone();
            string2 = this.parseContent(responseBody, encoding, clone);
        }
        catch (IOException e) {
            e.printStackTrace();
            string2 = "{\"error\": \"" + e.getMessage() + "\"}";
        }
        return string2;
    }

    private final String parseContent(ResponseBody responseBody, String encoding, Buffer clone) {
        String string2;
        Charset charset = Charset.forName("UTF-8");
        ResponseBody responseBody2 = responseBody;
        Intrinsics.checkNotNull((Object)responseBody2);
        MediaType contentType = responseBody2.contentType();
        if (contentType != null) {
            charset = contentType.charset(charset);
        }
        if (encoding != null && StringsKt.equals((String)encoding, (String)"gzip", (boolean)true)) {
            string2 = ZipHelper.Companion.decompressForGzip(clone.readByteArray(), Companion.convertCharset(charset));
        } else if (encoding != null && StringsKt.equals((String)encoding, (String)"zlib", (boolean)true)) {
            string2 = ZipHelper.Companion.decompressToStringForZlib(clone.readByteArray(), Companion.convertCharset(charset));
        } else {
            Charset charset2 = charset;
            Intrinsics.checkNotNull((Object)charset2);
            string2 = clone.readString(charset2);
        }
        return string2;
    }

    @NotNull
    public final String parseParams(@NotNull Request request) throws UnsupportedEncodingException {
        String string2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            String string3;
            RequestBody requestBody = request.newBuilder().build().body();
            if (requestBody == null) {
                return "";
            }
            RequestBody body = requestBody;
            Buffer requestbuffer = new Buffer();
            body.writeTo((BufferedSink)requestbuffer);
            Charset charset = Charset.forName("UTF-8");
            MediaType contentType = body.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            Charset charset2 = charset;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"charset");
            String json = requestbuffer.readString(charset2);
            if (UrlEncoderUtils.Companion.hasUrlEncoded(json)) {
                String string4 = URLDecoder.decode(json, Companion.convertCharset(charset));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"URLDecoder.decode(json, convertCharset(charset))");
                json = string4;
            }
            if ((string3 = CharacterHandler.Companion.jsonFormat(json)) == null) {
                string3 = "";
            }
            string2 = string3;
        }
        catch (IOException e) {
            e.printStackTrace();
            string2 = "{\"error\": \"" + e.getMessage() + "\"}";
        }
        return string2;
    }

    @Inject
    public RequestInterceptor() {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/swallow/fly/http/interceptor/RequestInterceptor$Level;", "", "(Ljava/lang/String;I)V", "NONE", "REQUEST", "RESPONSE", "ALL", "swallow_release"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level NONE;
        public static final /* enum */ Level REQUEST;
        public static final /* enum */ Level RESPONSE;
        public static final /* enum */ Level ALL;
        private static final /* synthetic */ Level[] $VALUES;

        static {
            Level[] levelArray = new Level[4];
            Level[] levelArray2 = levelArray;
            levelArray[0] = NONE = new Level();
            levelArray[1] = REQUEST = new Level();
            levelArray[2] = RESPONSE = new Level();
            levelArray[3] = ALL = new Level();
            $VALUES = levelArray;
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String string2) {
            return Enum.valueOf(Level.class, string2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000e\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0010\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u0011"}, d2={"Lcom/swallow/fly/http/interceptor/RequestInterceptor$Companion;", "", "()V", "convertCharset", "", "charset", "Ljava/nio/charset/Charset;", "isForm", "", "mediaType", "Lokhttp3/MediaType;", "isHtml", "isJson", "isParseable", "isPlain", "isText", "isXml", "swallow_release"})
    public static final class Companion {
        public final boolean isParseable(@Nullable MediaType mediaType) {
            MediaType mediaType2 = mediaType;
            return (mediaType2 != null ? mediaType2.type() : null) == null ? false : this.isText(mediaType) || this.isPlain(mediaType) || this.isJson(mediaType) || this.isForm(mediaType) || this.isHtml(mediaType) || this.isXml(mediaType);
        }

        public final boolean isText(@Nullable MediaType mediaType) {
            MediaType mediaType2 = mediaType;
            return (mediaType2 != null ? mediaType2.type() : null) == null ? false : Intrinsics.areEqual((Object)mediaType.type(), (Object)"text");
        }

        public final boolean isPlain(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"plain", (boolean)false, (int)2, null);
            }
            return bl;
        }

        public final boolean isJson(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"json", (boolean)false, (int)2, null);
            }
            return bl;
        }

        public final boolean isXml(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"xml", (boolean)false, (int)2, null);
            }
            return bl;
        }

        public final boolean isHtml(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"html", (boolean)false, (int)2, null);
            }
            return bl;
        }

        public final boolean isForm(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string2 = mediaType.subtype();
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"x-www-form-urlencoded", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @NotNull
        public final String convertCharset(@Nullable Charset charset) {
            String string2;
            String s = String.valueOf(charset);
            int i = StringsKt.indexOf$default((CharSequence)s, (String)"[", (int)0, (boolean)false, (int)6, null);
            if (i == -1) {
                string2 = s;
            } else {
                String string3 = s;
                int n = i + 1;
                int n2 = s.length() - 1;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, n2);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

