/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.http.di;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.swallow.fly.base.app.AppModule;
import com.swallow.fly.http.CoroutineCallAdapterFactory;
import com.swallow.fly.http.interceptor.GlobalHttpHandler;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ApplicationComponent;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\b\u0010\u0011\u001a\u00020\fH\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u0014H\u0017J<\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0007J\b\u0010\u001d\u001a\u00020\u0018H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/swallow/fly/http/di/ClientModule;", "", "()V", "TIME_OUT", "", "provideClient", "Lokhttp3/OkHttpClient;", "application", "Landroid/app/Application;", "configuration", "Lcom/swallow/fly/http/di/ClientModule$OkhttpConfiguration;", "builder", "Lokhttp3/OkHttpClient$Builder;", "intercept", "Lokhttp3/Interceptor;", "handler", "Lcom/swallow/fly/http/interceptor/GlobalHttpHandler;", "provideClientBuilder", "provideGson", "Lcom/google/gson/Gson;", "Lcom/swallow/fly/base/app/AppModule$GsonConfiguration;", "provideRetrofit", "Lretrofit2/Retrofit;", "Lcom/swallow/fly/http/di/ClientModule$RetrofitConfiguration;", "Lretrofit2/Retrofit$Builder;", "client", "httpUrl", "Lokhttp3/HttpUrl;", "goon", "provideRetrofitBuilder", "OkhttpConfiguration", "RetrofitConfiguration", "swallow_release"})
@InstallIn(value={ApplicationComponent.class})
public final class ClientModule {
    private static final long TIME_OUT;
    public static final ClientModule INSTANCE;

    @Singleton
    @Provides
    @NotNull
    public final Retrofit provideRetrofit(@NotNull Application application, @androidx.annotation.Nullable @Nullable RetrofitConfiguration configuration, @NotNull Retrofit.Builder builder, @NotNull OkHttpClient client, @NotNull HttpUrl httpUrl, @NotNull Gson goon) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpUrl, (String)"httpUrl");
        Intrinsics.checkNotNullParameter((Object)goon, (String)"goon");
        builder.baseUrl(httpUrl).client(client);
        RetrofitConfiguration retrofitConfiguration = configuration;
        if (retrofitConfiguration != null) {
            retrofitConfiguration.configRetrofit((Context)application, builder);
        }
        builder.addCallAdapterFactory((CallAdapter.Factory)CoroutineCallAdapterFactory.Companion.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)goon));
        Retrofit retrofit = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"builder.build()");
        return retrofit;
    }

    @Singleton
    @Provides
    @NotNull
    public final OkHttpClient provideClient(@NotNull Application application, @androidx.annotation.Nullable @Nullable OkhttpConfiguration configuration, @NotNull OkHttpClient.Builder builder, @androidx.annotation.Nullable @NotNull Interceptor intercept, @androidx.annotation.Nullable @Nullable GlobalHttpHandler handler) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)intercept, (String)"intercept");
            builder.connectTimeout(TIME_OUT, TimeUnit.SECONDS).readTimeout(TIME_OUT, TimeUnit.SECONDS);
            RetrofitUrlManager.getInstance().with(builder);
            if (handler != null) {
                builder.addInterceptor(new Interceptor(handler){
                    final /* synthetic */ GlobalHttpHandler $handler;

                    @NotNull
                    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                        return chain.proceed(this.$handler.onHttpRequestBefore(chain, chain.request()));
                    }
                    {
                        this.$handler = $captured_local_variable$0;
                    }
                });
            }
            builder.addInterceptor(intercept);
            OkhttpConfiguration okhttpConfiguration = configuration;
            if (okhttpConfiguration == null) break block1;
            okhttpConfiguration.configOkhttp((Context)application, builder);
        }
        return RetrofitUrlManager.getInstance().with(builder).build();
    }

    @Singleton
    @Provides
    @NotNull
    public final Retrofit.Builder provideRetrofitBuilder() {
        return new Retrofit.Builder();
    }

    @Singleton
    @Provides
    @NotNull
    public final OkHttpClient.Builder provideClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Singleton
    @Provides
    @NotNull
    public Gson provideGson(@NotNull Application application, @androidx.annotation.Nullable @Nullable AppModule.GsonConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        GsonBuilder builder = new GsonBuilder();
        AppModule.GsonConfiguration gsonConfiguration = configuration;
        if (gsonConfiguration != null) {
            gsonConfiguration.configGson((Context)application, builder);
        }
        Gson gson2 = builder.create();
        Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"builder.create()");
        return gson2;
    }

    private ClientModule() {
    }

    static {
        ClientModule clientModule;
        INSTANCE = clientModule = new ClientModule();
        TIME_OUT = 10L;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lcom/swallow/fly/http/di/ClientModule$RetrofitConfiguration;", "", "configRetrofit", "", "context", "Landroid/content/Context;", "builder", "Lretrofit2/Retrofit$Builder;", "swallow_release"})
    public static interface RetrofitConfiguration {
        public void configRetrofit(@NonNull @Nullable Context var1, @NonNull @Nullable Retrofit.Builder var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/swallow/fly/http/di/ClientModule$OkhttpConfiguration;", "", "configOkhttp", "", "context", "Landroid/content/Context;", "builder", "Lokhttp3/OkHttpClient$Builder;", "swallow_release"})
    public static interface OkhttpConfiguration {
        public void configOkhttp(@NonNull @NotNull Context var1, @NonNull @NotNull OkHttpClient.Builder var2);
    }
}

