/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.http;

import android.content.Context;
import android.net.ParseException;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.swallow.fly.http.ResponseErrorListener;
import com.swallow.fly.utils.FastUtils;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import retrofit2.HttpException;
import timber.log.Timber;

@Singleton
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/swallow/fly/http/ResponseErrorListenerImpl;", "Lcom/swallow/fly/http/ResponseErrorListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "convertStatusCode", "", "httpException", "Lretrofit2/HttpException;", "handleResponseError", "", "t", "swallow_release"})
public final class ResponseErrorListenerImpl
implements ResponseErrorListener {
    @NotNull
    private final Context context;

    private final String convertStatusCode(HttpException httpException) {
        return httpException.code() == 500 ? "\u670d\u52a1\u5668\u53d1\u751f\u9519\u8bef" : (httpException.code() == 404 ? "\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728" : (httpException.code() == 403 ? "\u8bf7\u6c42\u88ab\u670d\u52a1\u5668\u62d2\u7edd" : (httpException.code() == 401 ? "\u672a\u6388\u6743" : (httpException.code() == 307 ? "\u8bf7\u6c42\u88ab\u91cd\u5b9a\u5411\u5230\u5176\u4ed6\u9875\u9762" : httpException.message()))));
    }

    @Override
    @Nullable
    public Throwable handleResponseError(@Nullable Throwable t) {
        if (t == null) {
            FastUtils.INSTANCE.makeText(this.context, "\u672a\u77e5\u9519\u8bef");
            return t;
        }
        Timber.tag((String)"Catch-Error").w(t.getMessage(), new Object[0]);
        String msg = "\u672a\u77e5\u9519\u8bef";
        if (t instanceof UnknownHostException) {
            msg = "\u7f51\u7edc\u4e0d\u53ef\u7528";
        } else if (t instanceof SocketTimeoutException) {
            msg = "\u8bf7\u6c42\u7f51\u7edc\u8d85\u65f6";
        } else if (t instanceof HttpException) {
            msg = this.convertStatusCode((HttpException)t);
        } else if (t instanceof JsonParseException || t instanceof ParseException || t instanceof JSONException || t instanceof JsonIOException) {
            msg = "\u6570\u636e\u89e3\u6790\u9519\u8bef";
        } else if (t instanceof ConnectException) {
            msg = "\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc~";
        }
        FastUtils.INSTANCE.makeText(this.context, msg);
        return t;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Inject
    public ResponseErrorListenerImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }
}

