/*
 * Decompiled with CFR 0.152.
 */
package com.swallow.fly.base.app.config;

import com.swallow.fly.base.app.AppModule;
import com.swallow.fly.http.BaseUrl;
import com.swallow.fly.http.Preconditions;
import com.swallow.fly.http.ResponseErrorListener;
import com.swallow.fly.http.di.ClientModule;
import com.swallow.fly.http.interceptor.GlobalHttpHandler;
import com.swallow.fly.http.interceptor.RequestInterceptor;
import com.swallow.fly.http.printer.DefaultFormatPrinter;
import com.swallow.fly.http.printer.FormatPrinter;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ApplicationComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u0006H\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\rH\u0007J\n\u0010 \u001a\u0004\u0018\u00010\u0011H\u0007J\n\u0010!\u001a\u0004\u0018\u00010\u000fH\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007J\n\u0010#\u001a\u0004\u0018\u00010\u0016H\u0007J\b\u0010$\u001a\u00020\u0018H\u0007J\b\u0010%\u001a\u00020\u0004H\u0007J\n\u0010&\u001a\u0004\u0018\u00010\u001aH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/swallow/fly/base/app/config/GlobalConfigModule;", "", "()V", "EMPTY", "Lcom/swallow/fly/http/ResponseErrorListener;", "mApiUrl", "Lokhttp3/HttpUrl;", "mBaseUrl", "Lcom/swallow/fly/http/BaseUrl;", "mCacheFile", "Ljava/io/File;", "mErrorListener", "mFormatPrinter", "Lcom/swallow/fly/http/printer/FormatPrinter;", "mGsonConfiguration", "Lcom/swallow/fly/base/app/AppModule$GsonConfiguration;", "mHandler", "Lcom/swallow/fly/http/interceptor/GlobalHttpHandler;", "mInterceptors", "", "Lokhttp3/Interceptor;", "mOkhttpConfiguration", "Lcom/swallow/fly/http/di/ClientModule$OkhttpConfiguration;", "mPrintHttpLogLevel", "Lcom/swallow/fly/http/interceptor/RequestInterceptor$Level;", "mRetrofitConfiguration", "Lcom/swallow/fly/http/di/ClientModule$RetrofitConfiguration;", "builder", "Lcom/swallow/fly/base/app/config/GlobalConfigModule$Builder;", "getInstance", "provideBaseUrl", "provideFormatPrinter", "provideGlobalHttpHandler", "provideGsonConfiguration", "provideInterceptors", "provideOkhttpConfiguration", "providePrintHttpLogLevel", "provideResponseErrorListener", "provideRetrofitConfiguration", "Builder", "swallow_release"})
@InstallIn(value={ApplicationComponent.class})
public final class GlobalConfigModule {
    private static HttpUrl mApiUrl;
    private static BaseUrl mBaseUrl;
    private static GlobalHttpHandler mHandler;
    private static List<? extends Interceptor> mInterceptors;
    private static ResponseErrorListener mErrorListener;
    private static File mCacheFile;
    private static ClientModule.RetrofitConfiguration mRetrofitConfiguration;
    private static ClientModule.OkhttpConfiguration mOkhttpConfiguration;
    private static AppModule.GsonConfiguration mGsonConfiguration;
    private static RequestInterceptor.Level mPrintHttpLogLevel;
    private static FormatPrinter mFormatPrinter;
    private static final ResponseErrorListener EMPTY;
    public static final GlobalConfigModule INSTANCE;

    @NotNull
    public final Builder builder() {
        return new Builder();
    }

    @NotNull
    public final GlobalConfigModule getInstance(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        mApiUrl = builder.getApiUrl$swallow_release();
        mBaseUrl = builder.getBaseUrl$swallow_release();
        mHandler = builder.getHandler$swallow_release();
        mInterceptors = builder.getInterceptors$swallow_release();
        mErrorListener = builder.getResponseErrorListener$swallow_release();
        mCacheFile = builder.getCacheFile$swallow_release();
        mRetrofitConfiguration = builder.getRetrofitConfiguration$swallow_release();
        mOkhttpConfiguration = builder.getOkhttpConfiguration$swallow_release();
        mGsonConfiguration = builder.getGsonConfiguration$swallow_release();
        mPrintHttpLogLevel = builder.getPrintHttpLogLevel$swallow_release();
        mFormatPrinter = builder.getFormatPrinter$swallow_release();
        return this;
    }

    @Singleton
    @Provides
    @NotNull
    public final List<Interceptor> provideInterceptors() {
        List list = mInterceptors;
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    @Singleton
    @Provides
    @NotNull
    public final HttpUrl provideBaseUrl() {
        HttpUrl httpUrl;
        if (mBaseUrl != null) {
            BaseUrl baseUrl = mBaseUrl;
            Intrinsics.checkNotNull((Object)baseUrl);
            HttpUrl httpUrl2 = baseUrl.url();
            if (httpUrl2 != null) {
                return httpUrl2;
            }
        }
        if (mApiUrl == null) {
            HttpUrl httpUrl3 = HttpUrl.Companion.parse("https://api.github.com/");
            httpUrl = httpUrl3;
            Intrinsics.checkNotNull((Object)httpUrl3);
        } else {
            HttpUrl httpUrl4 = mApiUrl;
            httpUrl = httpUrl4;
            Intrinsics.checkNotNull((Object)httpUrl4);
        }
        return httpUrl;
    }

    @Singleton
    @Provides
    @Nullable
    public final GlobalHttpHandler provideGlobalHttpHandler() {
        return mHandler;
    }

    @Singleton
    @Provides
    @NotNull
    public final ResponseErrorListener provideResponseErrorListener() {
        ResponseErrorListener responseErrorListener = mErrorListener;
        if (responseErrorListener == null) {
            responseErrorListener = EMPTY;
        }
        return responseErrorListener;
    }

    @Singleton
    @Provides
    @Nullable
    public final ClientModule.RetrofitConfiguration provideRetrofitConfiguration() {
        return mRetrofitConfiguration;
    }

    @Singleton
    @Provides
    @Nullable
    public final ClientModule.OkhttpConfiguration provideOkhttpConfiguration() {
        return mOkhttpConfiguration;
    }

    @Singleton
    @Provides
    @Nullable
    public final AppModule.GsonConfiguration provideGsonConfiguration() {
        return mGsonConfiguration;
    }

    @Singleton
    @Provides
    @NotNull
    public final RequestInterceptor.Level providePrintHttpLogLevel() {
        RequestInterceptor.Level level;
        if (mPrintHttpLogLevel == null) {
            level = RequestInterceptor.Level.ALL;
        } else {
            RequestInterceptor.Level level2 = mPrintHttpLogLevel;
            level = level2;
            Intrinsics.checkNotNull((Object)((Object)level2));
        }
        return level;
    }

    @Singleton
    @Provides
    @Nullable
    public final FormatPrinter provideFormatPrinter() {
        return mFormatPrinter == null ? (FormatPrinter)new DefaultFormatPrinter() : mFormatPrinter;
    }

    private GlobalConfigModule() {
    }

    static {
        GlobalConfigModule globalConfigModule;
        INSTANCE = globalConfigModule = new GlobalConfigModule();
        EMPTY = new ResponseErrorListener(){

            @Nullable
            public Throwable handleResponseError(@Nullable Throwable t) {
                return new RuntimeException();
            }
        };
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020)J\u0010\u0010H\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010H\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010IJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010J\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u0010\u00104\u001a\u00020\u00002\b\u00104\u001a\u0004\u0018\u000105J\u0010\u0010:\u001a\u00020\u00002\b\u0010K\u001a\u0004\u0018\u00010;J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010@\u001a\u00020AR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u00104\u001a\u0004\u0018\u000105X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010E\u00a8\u0006L"}, d2={"Lcom/swallow/fly/base/app/config/GlobalConfigModule$Builder;", "", "()V", "apiUrl", "Lokhttp3/HttpUrl;", "getApiUrl$swallow_release", "()Lokhttp3/HttpUrl;", "setApiUrl$swallow_release", "(Lokhttp3/HttpUrl;)V", "baseUrl", "Lcom/swallow/fly/http/BaseUrl;", "getBaseUrl$swallow_release", "()Lcom/swallow/fly/http/BaseUrl;", "setBaseUrl$swallow_release", "(Lcom/swallow/fly/http/BaseUrl;)V", "cacheFile", "Ljava/io/File;", "getCacheFile$swallow_release", "()Ljava/io/File;", "setCacheFile$swallow_release", "(Ljava/io/File;)V", "formatPrinter", "Lcom/swallow/fly/http/printer/FormatPrinter;", "getFormatPrinter$swallow_release", "()Lcom/swallow/fly/http/printer/FormatPrinter;", "setFormatPrinter$swallow_release", "(Lcom/swallow/fly/http/printer/FormatPrinter;)V", "gsonConfiguration", "Lcom/swallow/fly/base/app/AppModule$GsonConfiguration;", "getGsonConfiguration$swallow_release", "()Lcom/swallow/fly/base/app/AppModule$GsonConfiguration;", "setGsonConfiguration$swallow_release", "(Lcom/swallow/fly/base/app/AppModule$GsonConfiguration;)V", "handler", "Lcom/swallow/fly/http/interceptor/GlobalHttpHandler;", "getHandler$swallow_release", "()Lcom/swallow/fly/http/interceptor/GlobalHttpHandler;", "setHandler$swallow_release", "(Lcom/swallow/fly/http/interceptor/GlobalHttpHandler;)V", "interceptors", "", "Lokhttp3/Interceptor;", "getInterceptors$swallow_release", "()Ljava/util/List;", "setInterceptors$swallow_release", "(Ljava/util/List;)V", "okhttpConfiguration", "Lcom/swallow/fly/http/di/ClientModule$OkhttpConfiguration;", "getOkhttpConfiguration$swallow_release", "()Lcom/swallow/fly/http/di/ClientModule$OkhttpConfiguration;", "setOkhttpConfiguration$swallow_release", "(Lcom/swallow/fly/http/di/ClientModule$OkhttpConfiguration;)V", "printHttpLogLevel", "Lcom/swallow/fly/http/interceptor/RequestInterceptor$Level;", "getPrintHttpLogLevel$swallow_release", "()Lcom/swallow/fly/http/interceptor/RequestInterceptor$Level;", "setPrintHttpLogLevel$swallow_release", "(Lcom/swallow/fly/http/interceptor/RequestInterceptor$Level;)V", "responseErrorListener", "Lcom/swallow/fly/http/ResponseErrorListener;", "getResponseErrorListener$swallow_release", "()Lcom/swallow/fly/http/ResponseErrorListener;", "setResponseErrorListener$swallow_release", "(Lcom/swallow/fly/http/ResponseErrorListener;)V", "retrofitConfiguration", "Lcom/swallow/fly/http/di/ClientModule$RetrofitConfiguration;", "getRetrofitConfiguration$swallow_release", "()Lcom/swallow/fly/http/di/ClientModule$RetrofitConfiguration;", "setRetrofitConfiguration$swallow_release", "(Lcom/swallow/fly/http/di/ClientModule$RetrofitConfiguration;)V", "addInterceptor", "interceptor", "baseurl", "", "globalHttpHandler", "listener", "swallow_release"})
    public static final class Builder {
        @Nullable
        private HttpUrl apiUrl;
        @Nullable
        private BaseUrl baseUrl;
        @Nullable
        private GlobalHttpHandler handler;
        @Nullable
        private List<Interceptor> interceptors;
        @Nullable
        private ResponseErrorListener responseErrorListener;
        @Nullable
        private File cacheFile;
        @Nullable
        private ClientModule.RetrofitConfiguration retrofitConfiguration;
        @Nullable
        private ClientModule.OkhttpConfiguration okhttpConfiguration;
        @Nullable
        private AppModule.GsonConfiguration gsonConfiguration;
        @Nullable
        private RequestInterceptor.Level printHttpLogLevel;
        @Nullable
        private FormatPrinter formatPrinter;

        @Nullable
        public final HttpUrl getApiUrl$swallow_release() {
            return this.apiUrl;
        }

        public final void setApiUrl$swallow_release(@Nullable HttpUrl httpUrl) {
            this.apiUrl = httpUrl;
        }

        @Nullable
        public final BaseUrl getBaseUrl$swallow_release() {
            return this.baseUrl;
        }

        public final void setBaseUrl$swallow_release(@Nullable BaseUrl baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Nullable
        public final GlobalHttpHandler getHandler$swallow_release() {
            return this.handler;
        }

        public final void setHandler$swallow_release(@Nullable GlobalHttpHandler globalHttpHandler) {
            this.handler = globalHttpHandler;
        }

        @Nullable
        public final List<Interceptor> getInterceptors$swallow_release() {
            return this.interceptors;
        }

        public final void setInterceptors$swallow_release(@Nullable List<Interceptor> list) {
            this.interceptors = list;
        }

        @Nullable
        public final ResponseErrorListener getResponseErrorListener$swallow_release() {
            return this.responseErrorListener;
        }

        public final void setResponseErrorListener$swallow_release(@Nullable ResponseErrorListener responseErrorListener) {
            this.responseErrorListener = responseErrorListener;
        }

        @Nullable
        public final File getCacheFile$swallow_release() {
            return this.cacheFile;
        }

        public final void setCacheFile$swallow_release(@Nullable File file) {
            this.cacheFile = file;
        }

        @Nullable
        public final ClientModule.RetrofitConfiguration getRetrofitConfiguration$swallow_release() {
            return this.retrofitConfiguration;
        }

        public final void setRetrofitConfiguration$swallow_release(@Nullable ClientModule.RetrofitConfiguration retrofitConfiguration) {
            this.retrofitConfiguration = retrofitConfiguration;
        }

        @Nullable
        public final ClientModule.OkhttpConfiguration getOkhttpConfiguration$swallow_release() {
            return this.okhttpConfiguration;
        }

        public final void setOkhttpConfiguration$swallow_release(@Nullable ClientModule.OkhttpConfiguration okhttpConfiguration) {
            this.okhttpConfiguration = okhttpConfiguration;
        }

        @Nullable
        public final AppModule.GsonConfiguration getGsonConfiguration$swallow_release() {
            return this.gsonConfiguration;
        }

        public final void setGsonConfiguration$swallow_release(@Nullable AppModule.GsonConfiguration gsonConfiguration) {
            this.gsonConfiguration = gsonConfiguration;
        }

        @Nullable
        public final RequestInterceptor.Level getPrintHttpLogLevel$swallow_release() {
            return this.printHttpLogLevel;
        }

        public final void setPrintHttpLogLevel$swallow_release(@Nullable RequestInterceptor.Level level) {
            this.printHttpLogLevel = level;
        }

        @Nullable
        public final FormatPrinter getFormatPrinter$swallow_release() {
            return this.formatPrinter;
        }

        public final void setFormatPrinter$swallow_release(@Nullable FormatPrinter formatPrinter) {
            this.formatPrinter = formatPrinter;
        }

        @NotNull
        public final Builder baseurl(@Nullable String baseUrl) {
            CharSequence charSequence = baseUrl;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                throw (Throwable)new NullPointerException("BaseUrl can not be empty");
            }
            this.apiUrl = HttpUrl.Companion.parse(baseUrl);
            return this;
        }

        @NotNull
        public final Builder baseurl(@Nullable BaseUrl baseUrl) {
            this.baseUrl = Preconditions.checkNotNull(baseUrl, BaseUrl.class.getCanonicalName() + "can not be null.", new Object[0]);
            return this;
        }

        @NotNull
        public final Builder globalHttpHandler(@Nullable GlobalHttpHandler handler) {
            this.handler = handler;
            return this;
        }

        @NotNull
        public final Builder addInterceptor(@NotNull Interceptor interceptor) {
            Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
            if (this.interceptors == null) {
                this.interceptors = new ArrayList();
            }
            List<Interceptor> list = this.interceptors;
            Intrinsics.checkNotNull(list);
            list.add(interceptor);
            return this;
        }

        @NotNull
        public final Builder responseErrorListener(@Nullable ResponseErrorListener listener) {
            this.responseErrorListener = listener;
            return this;
        }

        @NotNull
        public final Builder cacheFile(@Nullable File cacheFile) {
            this.cacheFile = cacheFile;
            return this;
        }

        @NotNull
        public final Builder retrofitConfiguration(@NotNull ClientModule.RetrofitConfiguration retrofitConfiguration) {
            Intrinsics.checkNotNullParameter((Object)retrofitConfiguration, (String)"retrofitConfiguration");
            this.retrofitConfiguration = retrofitConfiguration;
            return this;
        }

        @NotNull
        public final Builder okhttpConfiguration(@NotNull ClientModule.OkhttpConfiguration okhttpConfiguration) {
            Intrinsics.checkNotNullParameter((Object)okhttpConfiguration, (String)"okhttpConfiguration");
            this.okhttpConfiguration = okhttpConfiguration;
            return this;
        }

        @NotNull
        public final Builder gsonConfiguration(@Nullable AppModule.GsonConfiguration gsonConfiguration) {
            this.gsonConfiguration = gsonConfiguration;
            return this;
        }

        @NotNull
        public final Builder printHttpLogLevel(@Nullable RequestInterceptor.Level printHttpLogLevel) {
            this.printHttpLogLevel = Preconditions.checkNotNull(printHttpLogLevel, "The printHttpLogLevel can not be null, use RequestInterceptor.Level.NONE instead.", new Object[0]);
            return this;
        }

        @NotNull
        public final Builder formatPrinter(@Nullable FormatPrinter formatPrinter) {
            this.formatPrinter = Preconditions.checkNotNull(formatPrinter, FormatPrinter.class.getCanonicalName() + "can not be null.", new Object[0]);
            return this;
        }
    }
}

