/*
 * Decompiled with CFR 0.152.
 */
package com.flt.servicelib;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;

public class MessagingServiceConnection
implements ServiceConnection {
    private boolean bound;
    private Messenger transmitter;
    private Messenger receiver;
    private Listener listener;

    public void send(int message, Bundle bundle) throws Exception {
        if (!this.bound) {
            throw new IllegalStateException("Not yet bound.");
        }
        Message msg = Message.obtain(null, (int)message);
        msg.setData(bundle);
        msg.replyTo = this.receiver;
        this.transmitter.send(msg);
    }

    public boolean bound() {
        return this.bound;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void onServiceConnected(ComponentName name, IBinder binder) {
        this.bound = true;
        this.transmitter = new Messenger(binder);
        this.receiver = new Messenger((Handler)new IncomingHandler());
        if (this.listener != null) {
            this.listener.onConnected(this);
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.transmitter = null;
        this.receiver = null;
        this.bound = false;
        if (this.listener != null) {
            this.listener.onDisconnected(this);
        }
    }

    public class IncomingHandler
    extends Handler {
        public void handleMessage(Message msg) {
            if (MessagingServiceConnection.this.listener != null) {
                MessagingServiceConnection.this.listener.onMessageReceived(msg);
            }
        }
    }

    public static interface Listener {
        public void onConnected(MessagingServiceConnection var1);

        public void onDisconnected(MessagingServiceConnection var1);

        public void onMessageReceived(Message var1);
    }
}

