/*
 * Decompiled with CFR 0.152.
 */
package com.flt.servicelib;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

public abstract class AbstractPermissionExtensionAppCompatActivity
extends AppCompatActivity {
    private static final String TAG = "PermissionExtActivity";
    protected static final int ACTION_MANAGE_OVERLAY_PERMISSION_REQUEST_CODE = 7001;
    protected static final int REQUEST_ALL_PERMISSION_CODES = 7002;

    protected void setTitleBarToVersionWith(String title) {
        try {
            PackageInfo pInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
            String version = pInfo.versionName;
            this.getSupportActionBar().setTitle((CharSequence)(title + " " + version));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Exception encountered reading version number.", (Throwable)e);
        }
    }

    public boolean hasOverlayPermission() {
        return Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)this);
    }

    public void requestOverlayPermission() {
        if (!this.hasOverlayPermission()) {
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this.getPackageName())));
            this.startActivityForResult(intent, 7001);
        } else {
            this.onUnecessaryCallToRequestOverlayPermission();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (requestCode == 7001) {
                if (Settings.canDrawOverlays((Context)this)) {
                    this.onGrantedOverlayPermission();
                } else {
                    this.onRefusedOverlayPermission();
                }
            }
        } else if (requestCode == 7001) {
            this.onGrantedOverlayPermission();
        }
    }

    protected boolean anyOutstandingPermissions() {
        for (int i = 0; i < this.getRequiredPermissions().length; ++i) {
            if (!this.needsPermission(this.getRequiredPermissions()[i])) continue;
            return true;
        }
        return false;
    }

    protected void requestAllPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(this.getRequiredPermissions(), 7002);
        } else {
            this.onPermissionsGranted();
        }
    }

    protected boolean needsPermission(String permission) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.checkSelfPermission(permission) != 0;
        }
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 7002: {
                boolean aok = true;
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] == 0) continue;
                    aok = false;
                }
                if (aok) {
                    this.onPermissionsGranted();
                    break;
                }
                this.onNotAllPermissionsGranted();
            }
        }
    }

    protected abstract void onGrantedOverlayPermission();

    protected abstract void onRefusedOverlayPermission();

    protected abstract String[] getRequiredPermissions();

    protected abstract void onPermissionsGranted();

    protected abstract void onNotAllPermissionsGranted();

    protected abstract void onUnecessaryCallToRequestOverlayPermission();

    protected void informUser(String msg) {
        final String finalMsg = msg;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)AbstractPermissionExtensionAppCompatActivity.this, (CharSequence)finalMsg, (int)0).show();
            }
        });
    }

    protected void informUser(int string_resource) {
        this.informUser(this.getString(string_resource));
    }
}

