/*
 * Decompiled with CFR 0.152.
 */
package com.flt.servicelib;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.flt.servicelib.AbstractPermissionExtensionAppCompatActivity;
import com.flt.servicelib.IServiceBinder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractServiceBoundAppCompatActivity<ServiceClass, ServiceInterface>
extends AbstractPermissionExtensionAppCompatActivity {
    private static final String TAG = "ServiceBoundActivity";
    protected Class<ServiceClass> inferredServiceClass;
    protected ServiceInterface service;
    protected boolean bound;
    private ServiceConnection connection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder binder) {
            AbstractServiceBoundAppCompatActivity.this.service = ((IServiceBinder)binder).getService();
            AbstractServiceBoundAppCompatActivity.this.bound = true;
            AbstractServiceBoundAppCompatActivity.this.onBoundChanged(AbstractServiceBoundAppCompatActivity.this.bound);
        }

        public void onServiceDisconnected(ComponentName arg0) {
            AbstractServiceBoundAppCompatActivity.this.bound = false;
            AbstractServiceBoundAppCompatActivity.this.onBoundChanged(AbstractServiceBoundAppCompatActivity.this.bound);
        }
    };

    protected Class<ServiceClass> getServiceClass() {
        if (this.inferredServiceClass == null) {
            try {
                Type mySuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
                Type tType = ((ParameterizedType)mySuperclass).getActualTypeArguments()[0];
                String className = tType.toString().split(" ")[1];
                this.inferredServiceClass = Class.forName(className);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not determine Service class.", e);
            }
        }
        return this.inferredServiceClass;
    }

    protected void onStart() {
        super.onStart();
        Intent intent = new Intent((Context)this, this.getServiceClass());
        this.bindService(intent, this.connection, 1);
    }

    protected void onStop() {
        super.onStop();
        if (this.bound) {
            this.unbindService(this.connection);
            this.bound = false;
            this.onBoundChanged(this.bound);
        }
    }

    protected abstract void onBoundChanged(boolean var1);
}

