/*
 * Decompiled with CFR 0.152.
 */
package com.flt.servicelib;

import android.content.ComponentName;
import android.content.Intent;
import android.os.Message;
import com.flt.servicelib.AbstractPermissionExtensionAppCompatActivity;
import com.flt.servicelib.MessagingServiceConnection;

public abstract class AbstractMessengerServiceBoundAppCompatActivity
extends AbstractPermissionExtensionAppCompatActivity {
    protected ComponentName serviceComponentName;
    protected MessagingServiceConnection connection;
    protected boolean bound;

    protected ComponentName getServiceComponentName() {
        if (this.serviceComponentName == null) {
            this.serviceComponentName = this.createServiceComponentName();
        }
        return this.serviceComponentName;
    }

    protected abstract ComponentName createServiceComponentName();

    protected void bindToMessenger() {
        this.connection = new MessagingServiceConnection();
        this.connection.setListener(new MessagingServiceConnection.Listener(){

            @Override
            public void onConnected(MessagingServiceConnection source) {
                AbstractMessengerServiceBoundAppCompatActivity.this.bound = true;
                AbstractMessengerServiceBoundAppCompatActivity.this.onBoundChanged(true);
            }

            @Override
            public void onDisconnected(MessagingServiceConnection source) {
                AbstractMessengerServiceBoundAppCompatActivity.this.bound = false;
                AbstractMessengerServiceBoundAppCompatActivity.this.onBoundChanged(false);
            }

            @Override
            public void onMessageReceived(Message message) {
                AbstractMessengerServiceBoundAppCompatActivity.this.onMessageReceived(message);
            }
        });
        Intent intent = new Intent();
        intent.setComponent(this.getServiceComponentName());
        this.bindService(intent, this.connection, 1);
    }

    protected void onStart() {
        super.onStart();
        this.bindToMessenger();
    }

    protected void onStop() {
        super.onStop();
        if (this.bound) {
            this.connection.setListener(null);
            this.unbindService(this.connection);
            this.bound = false;
            this.onBoundChanged(this.bound);
        }
    }

    protected abstract void onMessageReceived(Message var1);

    protected abstract void onBoundChanged(boolean var1);
}

