/*
 * Decompiled with CFR 0.152.
 */
package com.flt.servicelib;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.provider.Settings;
import android.util.Log;
import android.widget.Toast;
import com.flt.servicelib.BackgroundServiceConfig;

public abstract class AbstractBackgroundService
extends Service {
    private static final String TAG = "BackgroundService";
    protected IBinder binder;
    protected Notification foreground_notification;
    protected NotificationChannel foreground_channel;
    protected BackgroundServiceConfig config;
    private static int NEXT_FOREGROUND_ID = 8000;
    protected int foreground_id;

    public void onCreate() {
        super.onCreate();
        this.foreground_id = NEXT_FOREGROUND_ID++;
        this.binder = this.createBinder();
        this.config = this.configure(new BackgroundServiceConfig());
        SharedPreferences prefs = this.getSharedPreferences(((Object)((Object)this)).getClass().getCanonicalName(), 0);
        this.restoreFrom(prefs);
        this.foreground_channel = this.buildForegroundChannel();
        if (this.config.show_notification) {
            this.goToForeground();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        SharedPreferences.Editor editor = this.getSharedPreferences(((Object)((Object)this)).getClass().getCanonicalName(), 0).edit();
        this.storeTo(editor);
        editor.commit();
        if (this.foreground_notification != null) {
            this.quitForeground();
        }
    }

    protected abstract void restoreFrom(SharedPreferences var1);

    protected abstract void storeTo(SharedPreferences.Editor var1);

    protected abstract IBinder createBinder();

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    protected abstract BackgroundServiceConfig configure(BackgroundServiceConfig var1);

    protected void goToForeground() {
        try {
            this.foreground_notification = this.buildStandardNotification();
            this.startForeground(this.foreground_id, this.foreground_notification);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Could not go to foreground with notification.", (Throwable)e);
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    protected NotificationChannel buildForegroundChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            Log.d((String)TAG, (String)"Building foreground channel for Android >= Oreo");
            NotificationManager mgr = (NotificationManager)this.getSystemService("notification");
            String id = ((Object)((Object)this)).getClass().getCanonicalName() + ".notifications.foreground";
            String name = this.config.notification_channel_name;
            String description = this.config.notification_channel_description;
            int importance = this.config.notification_channel_importance;
            NotificationChannel channel = new NotificationChannel(id, (CharSequence)name, importance);
            channel.setDescription(description);
            channel.enableLights(false);
            channel.enableVibration(false);
            mgr.createNotificationChannel(channel);
            return channel;
        }
        Log.d((String)TAG, (String)"Android < Oreo, no notification channel required.");
        return null;
    }

    protected Notification buildStandardNotification() {
        Intent launchIntent = new Intent((Context)this, this.config.notification_activity_class);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)launchIntent, (int)0);
        Notification.Builder builder = new Notification.Builder((Context)this);
        builder.setContentTitle((CharSequence)this.config.notification_title);
        builder.setContentText((CharSequence)this.config.notification_content);
        builder.setSmallIcon(this.config.notification_icon);
        builder.setPriority(this.config.notification_priority);
        builder.setContentIntent(pendingIntent);
        if (this.config.notification_ticker != null) {
            builder.setTicker((CharSequence)this.config.notification_ticker);
        }
        if (Build.VERSION.SDK_INT >= 26 && this.foreground_channel != null) {
            builder.setChannelId(this.foreground_channel.getId());
        }
        return builder.build();
    }

    protected void quitForeground() {
        this.stopForeground(true);
        this.foreground_notification = null;
    }

    public boolean hasOverlayPermission() {
        return Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)this);
    }

    protected boolean anyOutstandingPermissions() {
        for (int i = 0; i < this.getRequiredPermissions().length; ++i) {
            if (!this.needsPermission(this.getRequiredPermissions()[i])) continue;
            return true;
        }
        return false;
    }

    protected abstract String[] getRequiredPermissions();

    protected boolean needsPermission(String permission) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.checkSelfPermission(permission) != 0;
        }
        return false;
    }

    protected void informUser(int string_resource) {
        this.informUser(this.getString(string_resource));
    }

    protected void informUser(String msg) {
        final String finalMsg = msg;
        Handler h = new Handler(this.getMainLooper());
        h.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)AbstractBackgroundService.this, (CharSequence)finalMsg, (int)0).show();
            }
        });
    }
}

