/*
 * Copyright 2021-2022 FlowCentral Technologies Limited.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.flowcentraltech.flowcentral.chart.data;

import java.util.List;

import com.flowcentraltech.flowcentral.configuration.constants.ChartCategoryDataType;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.DataUtils;

/**
 * Chart categories object.
 * 
 * @author FlowCentral Technologies Limited
 * @since 1.0
 */
public abstract class ChartCategories<T> {

    private List<T> categories;

    public ChartCategories(List<T> categories) {
        this.categories = DataUtils.unmodifiableList(categories);
    }

    public ChartCategories(T[] categories) {
        this.categories = DataUtils.unmodifiableList(categories);
    }

    public abstract ChartCategoryDataType getCategoryType();

    public abstract Class<T> getDataType();

    public List<T> getCategories() {
        return categories;
    }

    public T[] categoriesToArray() {
        return DataUtils.toArray(getDataType(), categories);
    }

    public String categoriesToJsonArrayString() throws UnifyException {
        return DataUtils.asJsonArrayString(categoriesToArray());
    }

    public int size() {
        return categories.size();
    }
}
