/*
 * Decompiled with CFR 0.152.
 */
package com.flowcentraltech.flowcentral.chart.business;

import com.flowcentraltech.flowcentral.application.util.ApplicationEntityNameParts;
import com.flowcentraltech.flowcentral.application.util.ApplicationNameUtils;
import com.flowcentraltech.flowcentral.chart.business.ChartModuleService;
import com.flowcentraltech.flowcentral.chart.data.ChartData;
import com.flowcentraltech.flowcentral.chart.data.ChartDef;
import com.flowcentraltech.flowcentral.chart.data.ChartSnapshotDef;
import com.flowcentraltech.flowcentral.chart.entities.Chart;
import com.flowcentraltech.flowcentral.chart.entities.ChartQuery;
import com.flowcentraltech.flowcentral.chart.entities.ChartSnapshot;
import com.flowcentraltech.flowcentral.chart.entities.ChartSnapshotQuery;
import com.flowcentraltech.flowcentral.chart.entities.ChartSnapshotSeries;
import com.flowcentraltech.flowcentral.common.business.AbstractFlowCentralService;
import com.flowcentraltech.flowcentral.configuration.constants.ChartCategoryDataType;
import com.flowcentraltech.flowcentral.configuration.constants.ChartSeriesDataType;
import com.flowcentraltech.flowcentral.configuration.data.ModuleInstall;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Transactional;
import com.tcdng.unify.core.data.FactoryMap;
import com.tcdng.unify.core.database.Entity;
import com.tcdng.unify.core.database.Query;
import java.util.Arrays;
import java.util.List;

@Transactional
@Component(value="chart-moduleservice")
public class ChartModuleServiceImpl
extends AbstractFlowCentralService
implements ChartModuleService {
    private FactoryMap<String, ChartDef> chartDefFactoryMap = new FactoryMap<String, ChartDef>(true){

        protected boolean stale(String chartName, ChartDef chartDef) throws Exception {
            return (Long)ChartModuleServiceImpl.this.environment().value(Long.TYPE, "versionNo", (Query)new ChartQuery().id(chartDef.getId())) > chartDef.getVersion();
        }

        protected ChartDef create(String longName, Object ... arg1) throws Exception {
            ApplicationEntityNameParts nameParts = ApplicationNameUtils.getApplicationEntityNameParts((String)longName);
            Chart chart = (Chart)ChartModuleServiceImpl.this.environment().list((Query)new ChartQuery().applicationName(nameParts.getApplicationName()).name(nameParts.getEntityName()));
            if (chart == null) {
                throw new UnifyException("CHART_0001", new Object[]{longName});
            }
            ChartDef.Builder cdb = ChartDef.newBuilder(chart.getType(), chart.getPaletteType(), chart.getProvider(), chart.getRule(), longName, chart.getDescription(), chart.getId(), chart.getVersionNo());
            cdb.title(chart.getTitle()).subTitle(chart.getSubTitle()).width(chart.getWidth()).height(chart.getHeight()).showGrid(chart.isShowGrid()).showDataLabels(chart.isShowDataLabels()).stacked(chart.isStacked()).smooth(chart.isSmooth());
            return cdb.build();
        }
    };
    private FactoryMap<String, ChartSnapshotDef> chartSnapshotDefFactoryMap = new FactoryMap<String, ChartSnapshotDef>(true){

        protected boolean stale(String chartSnapshotName, ChartSnapshotDef chartSnapshotDef) throws Exception {
            return (Long)ChartModuleServiceImpl.this.environment().value(Long.TYPE, "versionNo", (Query)new ChartSnapshotQuery().id(chartSnapshotDef.getId())) > chartSnapshotDef.getVersion();
        }

        protected ChartSnapshotDef create(String chartSnapshotName, Object ... arg1) throws Exception {
            ChartSnapshot chartSnapshot = (ChartSnapshot)ChartModuleServiceImpl.this.environment().list((Query)new ChartSnapshotQuery().name(chartSnapshotName));
            if (chartSnapshot == null) {
                throw new UnifyException("CHART_0002", new Object[]{chartSnapshotName});
            }
            ChartData.Builder cdb = ChartData.newBuilder();
            cdb.categories(chartSnapshot.getCategoryDataType(), chartSnapshot.getCategories());
            for (ChartSnapshotSeries series : chartSnapshot.getSeriesList()) {
                cdb.addSeries(series.getSeriesDataType(), series.getName(), series.getSeries());
            }
            ChartData chartData = cdb.build();
            return new ChartSnapshotDef(chartSnapshot.getName(), chartSnapshot.getDescription(), chartData, chartSnapshot.getId(), chartSnapshot.getVersionNo());
        }
    };

    @Override
    public List<Chart> findCharts(ChartQuery query) throws UnifyException {
        return this.environment().listAll((Query)query);
    }

    @Override
    public Chart findChart(Long chartId) throws UnifyException {
        return (Chart)this.environment().find(Chart.class, (Object)chartId);
    }

    @Override
    public List<Long> findChartIdList(String applicationName) throws UnifyException {
        return this.environment().valueList(Long.class, "id", (Query)new ChartQuery().applicationName(applicationName));
    }

    @Override
    public List<ChartSnapshot> findChartSnapshots(ChartSnapshotQuery query) throws UnifyException {
        return this.environment().listAll((Query)query);
    }

    @Override
    public ChartDef getChartDef(String chartName) throws UnifyException {
        return (ChartDef)((Object)this.chartDefFactoryMap.get((Object)chartName));
    }

    @Override
    public ChartSnapshotDef getChartSnapshotDef(String snapshotName) throws UnifyException {
        return (ChartSnapshotDef)this.chartSnapshotDefFactoryMap.get((Object)snapshotName);
    }

    @Override
    public boolean isChartSnapshotExist(String snapshotName) throws UnifyException {
        return this.environment().countAll((Query)new ChartSnapshotQuery().name(snapshotName)) > 0;
    }

    @Override
    public void saveChartSnapshot(ChartSnapshot chartSnapshot) throws UnifyException {
        if (this.environment().countAll((Query)new ChartSnapshotQuery().name(chartSnapshot.getName())) == 0) {
            this.environment().create((Entity)chartSnapshot);
        } else {
            this.environment().updateByIdVersion((Entity)chartSnapshot);
        }
    }

    protected void doInstallModuleFeatures(ModuleInstall moduleInstall) throws UnifyException {
        ChartSnapshot chartSnapshot;
        if (this.environment().countAll((Query)new ChartSnapshotQuery().name("sampleSalesChartSnapshot")) == 0) {
            chartSnapshot = new ChartSnapshot(ChartCategoryDataType.STRING, "sampleSalesChartSnapshot", "Sample Sales Chart Snapshot", "[\"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\"]");
            chartSnapshot.setSeriesList(Arrays.asList(new ChartSnapshotSeries(ChartSeriesDataType.INTEGER, "Sales", "[60,40,30,50,70,55,62]")));
            this.environment().create((Entity)chartSnapshot);
        }
        if (this.environment().countAll((Query)new ChartSnapshotQuery().name("sampleCostsChartSnapshot")) == 0) {
            chartSnapshot = new ChartSnapshot(ChartCategoryDataType.STRING, "sampleCostsChartSnapshot", "Sample Costs Chart Snapshot", "[\"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\"]");
            chartSnapshot.setSeriesList(Arrays.asList(new ChartSnapshotSeries(ChartSeriesDataType.INTEGER, "Costs", "[25,40,35,38,40,58,50]")));
            this.environment().create((Entity)chartSnapshot);
        }
        if (this.environment().countAll((Query)new ChartSnapshotQuery().name("sampleSalesAndCostsChartSnapshot")) == 0) {
            chartSnapshot = new ChartSnapshot(ChartCategoryDataType.STRING, "sampleSalesAndCostsChartSnapshot", "Sample Sales and Costs Chart Snapshot", "[\"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\"]");
            chartSnapshot.setSeriesList(Arrays.asList(new ChartSnapshotSeries(ChartSeriesDataType.INTEGER, "Sales", "[60,40,30,50,70,55,62]"), new ChartSnapshotSeries(ChartSeriesDataType.INTEGER, "Costs", "[25,40,35,38,40,58,50]")));
            this.environment().create((Entity)chartSnapshot);
        }
    }
}

