/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.registry;

import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class TaskHandlerRegistry
extends AbstractHandlerRegistry<TaskHandler> {
    private static final Logger LOGGER = LogFactory.getLogger(TaskHandlerRegistry.class);
    private Map<String, TaskHandler> commandToTaskHandler = new ConcurrentHashMap<String, TaskHandler>();
    private Map<String, Integer> maxPoolSize = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> corePoolSize = new ConcurrentHashMap<String, Integer>();

    public TaskHandler getTaskHandlerByCommand(String commandString) {
        return this.commandToTaskHandler.get(commandString);
    }

    public Integer getMaxPoolSize(String poolOrCommandName) {
        return this.maxPoolSize.get(poolOrCommandName);
    }

    public Integer getCorePoolSize(String poolOrCommandName) {
        return this.corePoolSize.get(poolOrCommandName);
    }

    @Override
    protected Class<TaskHandler> getHandlerType() {
        return TaskHandler.class;
    }

    @Override
    protected void postInitHandler(TaskHandler taskHandler) {
        for (String commandName : taskHandler.getCommands()) {
            LOGGER.info("Registering task handler " + taskHandler.getName() + " with command " + commandName);
            if (!this.commandToTaskHandler.containsValue(taskHandler)) {
                this.initializeConcurrencyPoolMap(taskHandler);
            }
            if (this.commandToTaskHandler.get(commandName) != null) {
                throw new IllegalArgumentException("Command " + commandName + " is already registered with handler " + this.commandToTaskHandler.get(commandName).getName());
            }
            this.commandToTaskHandler.put(commandName, taskHandler);
        }
    }

    @Override
    protected void postUnregisterHandler(TaskHandler handler) {
        for (String commandName : handler.getCommands()) {
            this.commandToTaskHandler.remove(commandName);
        }
    }

    private void initializeConcurrencyPoolMap(TaskHandler taskHandler) {
        if (taskHandler instanceof HystrixTaskHandler) {
            HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)taskHandler;
            Map<String, Integer> threadParams = hystrixTaskHandler.getConcurrentPoolSizeParams();
            for (String string : threadParams.keySet()) {
                this.maxPoolSize.put(string, threadParams.get(string));
            }
            Map<String, Integer> commandParams = hystrixTaskHandler.getCommandPoolSizeParams();
            for (String string : commandParams.keySet()) {
                this.maxPoolSize.put(string, commandParams.get(string));
            }
            Map<String, Integer> map = hystrixTaskHandler.getCoreConcurrentPoolSizeParams();
            for (String corePoolSizeParam : map.keySet()) {
                this.corePoolSize.put(corePoolSizeParam, map.get(corePoolSizeParam));
            }
            Map<String, Integer> map2 = hystrixTaskHandler.getCoreCommandPoolSizeParams();
            for (String coreCommandPoolSizeParam : map2.keySet()) {
                this.corePoolSize.put(coreCommandPoolSizeParam, map2.get(coreCommandPoolSizeParam));
            }
        }
    }
}

