/*
 * Decompiled with CFR 0.152.
 */
package com.fleksy.swipedetector.model;

import com.fleksy.swipedetector.model.Direction;
import com.fleksy.swipedetector.model.FPoint;
import com.fleksy.swipedetector.tool.Calculator;
import java.util.ArrayList;
import java.util.List;

public class Gesture {
    public static final int HEAD = 0;
    public static final int BODY = 1;
    public static final int TAIL = 3;
    private final int ID;
    private final ArrayList<FPoint> points;
    private final ArrayList<Gesture> children;
    private Gesture parent;
    private Object TAG;
    private boolean holding = false;
    private boolean refined = false;
    private boolean ignored = false;
    private boolean phantom = false;
    private boolean process = false;
    private Direction direction = Direction.UNDEFINED;

    public Gesture(Object TAG, int ID, float x, float y, long eventTime, Gesture parent) {
        this.ID = ID;
        this.TAG = TAG;
        this.parent = parent;
        this.points = new ArrayList();
        this.children = new ArrayList();
        this.addPoint(new FPoint(0, x, y, eventTime));
        if (parent != null) {
            parent.haveChild(this);
        }
    }

    public final int getId() {
        return this.ID;
    }

    public final Object getTag() {
        return this.TAG;
    }

    public final void process() {
        this.process = true;
    }

    public final boolean processed() {
        return this.process;
    }

    public final void setHold(boolean holding) {
        this.holding = holding;
    }

    public final boolean isHeld() {
        return this.holding;
    }

    public final List<FPoint> getPoints() {
        return this.points;
    }

    public final void addPoint(FPoint p) {
        this.points.add(p);
    }

    public final boolean pointExists(int index) {
        return index < this.points.size() && index >= 0;
    }

    public final FPoint getPointAt(int index) {
        if (this.pointExists(index)) {
            return this.points.get(index);
        }
        return null;
    }

    public final FPoint getFirstPoint() {
        return this.getPointAt(0);
    }

    public final FPoint getLastPoint() {
        return this.getPointAt(this.points.size() - 1);
    }

    public final void editPoint(int index, FPoint p) {
        if (this.pointExists(index)) {
            this.points.set(index, p);
        }
    }

    private long getPointTime(FPoint point) {
        if (point != null) {
            return point.getTime();
        }
        return -1L;
    }

    private float getPointX(FPoint point) {
        if (point != null) {
            return point.getX();
        }
        return -1.0f;
    }

    private float getPointY(FPoint point) {
        if (point != null) {
            return point.getY();
        }
        return -1.0f;
    }

    public final long getPressTime() {
        return this.getPointTime(this.getFirstPoint());
    }

    public final long getReleaseTime() {
        return this.getPointTime(this.getLastPoint());
    }

    public final long getTimeTaken() {
        return this.getReleaseTime() - this.getPressTime();
    }

    public final float getDownX() {
        return this.getPointX(this.getFirstPoint());
    }

    public final float getDownY() {
        return this.getPointY(this.getFirstPoint());
    }

    public final float getUpX() {
        return this.getPointX(this.getLastPoint());
    }

    public final float getUpY() {
        return this.getPointY(this.getLastPoint());
    }

    public final float getDeltaX() {
        return Calculator.calcDeltaF(this.getDownX(), this.getUpX());
    }

    public final float getDeltaY() {
        return Calculator.calcDeltaF(this.getDownY(), this.getUpY());
    }

    public final double getLength() {
        return Calculator.calcPointLength(this.getFirstPoint(), this.getLastPoint());
    }

    public final double getRadian() {
        double radian = Calculator.findRads(this.getDeltaX(), -this.getDeltaY());
        if (radian < 0.0) {
            radian += (double)6.28f;
        }
        return radian;
    }

    public final double getNormalRadian() {
        double radian = Calculator.findRads(-this.getDeltaX(), this.getDeltaY());
        if (radian < 0.0) {
            radian += (double)6.28f;
        }
        return radian;
    }

    public final boolean isPhantom() {
        return this.phantom;
    }

    public final void setPhantom(boolean phantom) {
        this.phantom = phantom;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(Direction direction) {
        this.direction = direction;
    }

    public final Gesture getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public final Gesture leaveParent() {
        if (this.parent != null) {
            this.parent.loseChild(this);
        }
        return this.parent;
    }

    public final Gesture getParent() {
        return this.parent;
    }

    public final void setParent(Gesture adopter) {
        if (this.parent != null) {
            this.parent.loseChild(this);
        }
        this.parent = adopter;
        if (this.parent != null) {
            this.parent.haveChild(this);
        }
    }

    public final boolean canLiberate(int target) {
        return this.children.size() >= target;
    }

    public final Gesture getLiberator() {
        if (!this.hasChildren()) {
            return this;
        }
        return this.children.get(this.children.size() - 1);
    }

    public final void haveChild(Gesture child) {
        this.children.add(child);
    }

    private void loseChild(Gesture child) {
        this.children.remove(child);
    }

    public final void setIgnore(boolean ignore) {
        this.ignored = ignore;
    }

    public final boolean ignore() {
        return this.ignored;
    }

    public final void refine() {
        this.refined = true;
    }

    public final boolean refined() {
        return this.refined;
    }

    public final boolean orphaned() {
        return this.parent == null;
    }

    public final boolean freed() {
        return this.orphaned() && this.refined();
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    public final boolean hasChildren() {
        return this.children.size() > 0;
    }

    public final int getChildCount() {
        return this.children.size();
    }

    public final List<Gesture> getChildren() {
        return this.children;
    }

    public final List<Gesture> abandonChildren() {
        if (this.children.isEmpty()) {
            return this.children;
        }
        ArrayList<Gesture> abandoned = new ArrayList<Gesture>();
        for (int i = 0; i < this.children.size(); ++i) {
            Gesture child = this.children.get(i);
            child.parent = null;
            abandoned.add(child);
        }
        this.children.clear();
        return abandoned;
    }

    public final void adoptChildrenFrom(Gesture old) {
        for (int i = 0; i < old.getChildCount(); ++i) {
            Gesture child = old.children.get(i);
            child.parent = this;
            this.haveChild(child);
        }
        old.children.clear();
    }
}

