/*
 * Decompiled with CFR 0.152.
 */
package com.fleksy.swipedetector;

import com.fleksy.swipedetector.ProcessLogicProvider;
import com.fleksy.swipedetector.model.Direction;
import com.fleksy.swipedetector.model.FPoint;
import com.fleksy.swipedetector.model.Gesture;
import com.fleksy.swipedetector.tool.Calculator;
import java.util.ArrayList;
import java.util.List;

abstract class SwipeDetector
extends ProcessLogicProvider {
    private boolean isPhantomSwipe;
    private float weight;
    private FPoint p1;
    private FPoint p2;
    private int perfect;
    private int directions;
    private long deltaTime;
    private double eRad;
    private double prevLn;
    private double totalLn;
    private double prevRad;
    private double prevDelta;
    private float phantomLn;
    private Direction prevDir;
    private Direction direction;
    private boolean badAngle;
    private boolean badDirections;
    private List<Double> lengths = new ArrayList<Double>();

    public SwipeDetector(float pixelSize) {
        super(pixelSize);
    }

    protected final String getData(Gesture swipe) {
        this.check(swipe);
        return this.getRawOutput();
    }

    protected Gesture check(Gesture swipe) {
        List<FPoint> ps;
        this.reset();
        if (this.debugging()) {
            this.println();
        }
        if (this.badFPoint((ps = swipe.getPoints()).size())) {
            if (this.debugging()) {
                this.println("BAD SWIPE/BAD FPoints!");
            }
            return swipe;
        }
        this.deltaTime = swipe.getLastPoint().getTime() - swipe.getFirstPoint().getTime();
        for (int i = 0; i < ps.size() - 1; ++i) {
            double currRad;
            double dRad;
            float dY;
            this.p1 = ps.get(i);
            this.p2 = ps.get(i + 1);
            float dX = Calculator.calcDeltaF(this.p2.getX(), this.p1.getX());
            double length = Calculator.calcLength(dX, dY = Calculator.calcDeltaF(this.p2.getY(), this.p1.getY()));
            if (!this.isHolding(length, dRad = Calculator.getDeltaRad(currRad = Calculator.findRads(dX, -dY), this.prevRad))) {
                this.lengths.add(length);
                this.incrementRadError(dRad, this.p1.getState(), length);
                this.bodyScan(this.p1.getState(), dRad, length, this.prevLn);
            }
            Direction dir = Calculator.getDirection(Calculator.calcDeltaF(this.p1.getX(), this.p2.getX()), Calculator.calcDeltaF(this.p1.getY(), this.p2.getY()), false);
            this.badDirections(dir, this.p2.getX(), this.p2.getY());
            if (this.p1.getState() == 0) {
                this.printData(this.p1.getState(), this.prevRad, this.prevDelta, this.p1.getX(), this.p1.getY(), this.prevLn, this.p1.getTime(), Direction.UNDEFINED);
            }
            if (this.p2.getState() != 0) {
                this.printData(i + 1, currRad, dRad, this.p2.getX(), this.p2.getY(), length, this.p2.getTime(), dir);
            }
            this.setPrevious(length, currRad, dRad, dir);
        }
        this.finalScan(swipe, this.eRad);
        swipe.setPhantom(this.isPhantomSwipe);
        return swipe;
    }

    private boolean badFPoint(int size) {
        if (size <= 2) {
            this.isPhantomSwipe = true;
            return true;
        }
        return false;
    }

    private void incrementRadError(double deltaRad, int s1, double ln) {
        if (deltaRad > (double)this.getMinChangeInRads() && s1 != 0 && ln > 0.0) {
            this.eRad += deltaRad;
            if (this.debugging()) {
                this.println("Delta Err: " + this.eRad);
            }
        }
    }

    private boolean isHolding(double ln, double deltaRad) {
        deltaRad = (double)Math.round(deltaRad * 1000.0) / 1000.0;
        if (this.p1.getState() == 0 && deltaRad <= 0.0) {
            if (ln > 0.0) {
                this.lengths.add(ln);
            } else if (this.debugging()) {
                this.println("EARLY ZERO LENGTH");
            }
            this.phantomLn = (float)((double)this.phantomLn + ln);
            this.p2.setState(0);
            return true;
        }
        if (ln == 0.0) {
            if (this.debugging()) {
                this.println("LATE ZERO LENGTH");
            }
            return true;
        }
        return false;
    }

    private void badDirections(Direction dir, float x, float y) {
        if (x <= 0.0f || x >= this.getWidth()) {
            return;
        }
        if (y <= 0.0f || y >= this.getHeight()) {
            return;
        }
        if (dir == Direction.UNDEFINED) {
            return;
        }
        if (dir != this.prevDir) {
            this.directions = 0;
        }
        if (dir != this.direction) {
            ++this.directions;
            if (this.directions == 3) {
                if (this.direction != Direction.UNDEFINED) {
                    this.weight += 1.0f;
                    this.badDirections = true;
                    if (this.debugging()) {
                        this.println("BAD DIRECTIONS");
                    }
                }
                this.direction = dir;
                if (this.debugging()) {
                    this.println("DIRECTION: " + (Object)((Object)this.direction));
                }
            }
        } else {
            this.directions = 0;
        }
    }

    private void bodyScan(int p1, double deltaRad, double ln, double prevLn) {
        if (p1 == 1) {
            this.tooPerfect(deltaRad);
            this.crazyAngle(deltaRad, ln, prevLn);
        }
    }

    private void tooPerfect(double deltaRad) {
        if (deltaRad == 0.0) {
            ++this.perfect;
            if ((float)this.perfect == this.getMaxConcurrentRads()) {
                this.weight += 0.5f;
                if (this.debugging()) {
                    this.println(".:*PERFECT COMBO*:. " + this.weight);
                }
            }
        } else {
            this.perfect = 0;
        }
    }

    private void crazyAngle(double deltaRad, double ln, double pln) {
        if (deltaRad >= (double)this.getAvgChangeInRads() && ln > (double)this.getPixel() && pln > (double)this.getPixel()) {
            boolean bl = this.badAngle = !this.badAngle;
            if (this.debugging()) {
                this.println("OVER " + Math.round(Math.toDegrees(this.getAvgRadianError() * 100.0f) / 100.0) + " ANGLE");
            }
            if (!this.badAngle) {
                this.eRad = 0.0;
            }
        } else if (this.badAngle) {
            this.weight += 1.0f;
            this.badAngle = false;
            if (this.debugging()) {
                this.println("CRAZY ANGLE " + this.weight);
            }
        }
    }

    private void finalScan(Gesture swipe, double err) {
        this.totalLn = Calculator.calcTotal(this.lengths);
        if (this.lengths.size() > 2) {
            float deltaV = Calculator.getDeltaVelocity(this.lengths, this.getAvgSpeedForVelocity());
            double avg = Calculator.calcAverage(this.totalLn, this.lengths.size());
            double stdDev = Calculator.calcStandardDeviation(this.lengths);
            this.checkErrors(err, avg);
            this.isJumping(this.lengths, avg);
            this.phantomLengths(err);
            this.badEnding(avg);
            this.terribleSwipe(stdDev);
            this.verticalSave(swipe.getRadian(), this.totalLn);
            this.label(this.totalLn, err, avg);
            if (this.debugging()) {
                this.println("DeltaV: " + deltaV + " Length: " + this.totalLn);
                this.println("N Std Dev: " + stdDev + " Avg L: " + avg);
            }
        } else {
            this.tooTiny(swipe.getRadian(), this.totalLn);
        }
        if (this.debugging()) {
            this.println("Deg Err: " + (double)Math.round(err * 1000.0) / 1000.0);
            this.println("Time Taken: " + this.deltaTime);
        }
    }

    private void isJumping(List<Double> nums, double avg) {
        for (int i = 0; i < nums.size(); ++i) {
            if (!(nums.get(i) > (double)this.getJumpLength())) continue;
            this.weight += 1.0f;
            if (!this.debugging()) continue;
            this.println("JUMPER " + this.weight);
        }
    }

    private void checkErrors(double e, double avg) {
        if (e > (double)this.getAvgRadianError()) {
            this.weight += 1.0f;
            if (this.debugging()) {
                this.println("ERRORS " + this.weight);
            }
            if (e > (double)this.getMaxRadianError() && avg > (double)this.getAverageLength()) {
                this.weight = (float)((double)this.weight + (e - (double)this.getMaxRadianError()));
                this.weight = (float)Math.round(this.weight * 10.0f) / 10.0f;
                if (this.debugging()) {
                    this.println("MAX ERRORS " + this.weight);
                }
            }
        }
    }

    private void phantomLengths(double e) {
        if (this.phantomLn > 0.0f && e > (double)this.getAvgRadianError()) {
            this.weight += 1.0f;
            if (e > (double)this.getMaxRadianError()) {
                this.weight += this.phantomLn;
                if (this.debugging()) {
                    this.println("PHANTOM LINE! " + this.weight);
                }
            } else if (this.debugging()) {
                this.println("PHANTOM LINE? " + this.weight);
            }
        }
    }

    private boolean verticalSave(double rad, double ln) {
        if ((rad > (double)4.3f && rad < (double)5.1f || rad > (double)0.8f && rad < (double)2.4f) && !this.badDirections && ln > (double)this.getNiceLength()) {
            this.weight = (float)((double)this.weight / 1.5);
            if (this.debugging()) {
                this.println("VERTICAL SAVE! " + this.weight);
            }
            return true;
        }
        return false;
    }

    private void badEnding(double avg) {
        int index = this.lengths.size() - 1;
        int sub = 1;
        if (this.lengths.get(index) + this.lengths.get(index - sub) <= avg * (double)this.getAvgEndLengthRatio()) {
            this.weight += 0.5f;
            if (this.debugging()) {
                this.println("BAD ENDING " + this.weight);
            }
        }
    }

    private void terribleSwipe(double std) {
        if (std >= (double)this.getMaxStandardDeviation()) {
            this.weight += 1.0f;
            if (this.debugging()) {
                this.println("STD " + Math.round(std) + " TERRIBLE SWIPE " + this.weight);
            }
        }
    }

    private void tooTiny(double rad, double ln) {
        if (this.lengths.size() > 0) {
            float totalL = 0.0f;
            for (double length : this.lengths) {
                totalL = (float)((double)totalL + length);
            }
            if (this.lengths.get(this.lengths.size() - 1) < (double)(totalL * 0.25f) && !this.verticalSave(rad, ln)) {
                this.isPhantomSwipe = true;
                if (this.debugging()) {
                    this.println("TINY ENDING");
                }
            }
        }
    }

    private void label(double ln, double err, double avg) {
        if (ln > (double)this.getNiceLength() && !this.badDirections) {
            this.weight = (float)((double)this.weight / (ln / (double)this.getNiceLength()));
            if (this.debugging()) {
                this.println("GOOD LENGTH REDEMPTION " + this.weight);
            }
        }
        if (this.weight < this.getMaxWeight()) {
            this.isPhantomSwipe = false;
            if (this.debugging()) {
                this.println("GOOD SWIPE: " + this.weight);
            }
        } else {
            this.isPhantomSwipe = true;
            if (this.debugging()) {
                this.println("BAD SWIPE: " + this.weight);
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.direction = Direction.UNDEFINED;
        this.prevDir = Direction.UNDEFINED;
        this.isPhantomSwipe = false;
        this.badDirections = false;
        this.badAngle = false;
        this.phantomLn = 0.0f;
        this.prevDelta = 0.0;
        this.perfect = 0;
        this.prevRad = 0.0;
        this.totalLn = 0.0;
        this.weight = 0.0f;
        this.prevLn = 0.0;
        this.eRad = 0.0;
        this.lengths.clear();
    }

    private void setPrevious(double l, double r, double d, Direction s) {
        this.prevLn = l;
        this.prevRad = r;
        this.prevDelta = d;
        this.prevDir = s;
    }
}

