/*
 * Decompiled with CFR 0.152.
 */
package com.fleksy.swipedetector;

import com.fleksy.swipedetector.model.Direction;

abstract class ProcessLogicProvider {
    private float viewWidth;
    private float viewHeight;
    private final float pixelSize;
    private StringBuilder out = new StringBuilder();

    public ProcessLogicProvider(float pixelSize) {
        this.pixelSize = pixelSize;
    }

    protected final float getPixel() {
        return this.pixelSize;
    }

    protected final float getWidth() {
        return this.viewWidth;
    }

    protected final float getHeight() {
        return this.viewHeight;
    }

    protected final void updateDimensions(float width, float height) {
        this.viewWidth = width;
        this.viewHeight = height;
    }

    protected float getJumpLength() {
        return this.viewWidth / 8.0f;
    }

    protected float getNiceLength() {
        return this.viewHeight / 8.0f;
    }

    protected float getAverageLength() {
        return this.viewHeight / 40.0f;
    }

    protected float getMaxConcurrentRads() {
        return 3.0f;
    }

    protected float getMaxWeight() {
        return 4.0f;
    }

    protected float getAvgRadianError() {
        return 1.57f;
    }

    protected float getMaxRadianError() {
        return 3.14f;
    }

    protected float getMinChangeInRads() {
        return 0.174f;
    }

    protected float getAvgChangeInRads() {
        return 0.785f;
    }

    protected float getMaxStandardDeviation() {
        return 16.0f;
    }

    protected float getAvgEndLengthRatio() {
        return 0.9f;
    }

    protected float getAvgSpeedForVelocity() {
        return 0.7f;
    }

    protected void reset() {
        this.out.setLength(0);
    }

    protected boolean debugging() {
        return false;
    }

    protected final String getRawOutput() {
        return this.out.toString();
    }

    protected final void printData(int state, double rad, double dRad, float x, float y, double l, float t, Direction dir) {
        if (rad < 0.0) {
            rad += 6.28;
        }
        if (this.debugging()) {
            this.println(state + " d" + (double)Math.round(rad * 100.0) / 100.0 + "b [" + (double)Math.round(dRad * 1000.0) / 1000.0 + "] <" + Math.round(x) + ", " + Math.round(y) + "> l: " + (double)Math.round(l * 1000.0) / 1000.0 + " Dir: " + (Object)((Object)dir));
        }
    }

    protected final void println() {
        this.out.append("\n");
    }

    protected final void println(String in) {
        this.out.append(in);
        this.println();
    }
}

