/*
 * Decompiled with CFR 0.152.
 */
package com.fleksy.swipedetector;

import android.graphics.RectF;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.fleksy.swipedetector.TouchRefinery;
import com.fleksy.swipedetector.model.Direction;
import com.fleksy.swipedetector.model.FPoint;
import com.fleksy.swipedetector.model.Gesture;
import com.fleksy.swipedetector.tool.Calculator;
import java.util.ArrayList;
import java.util.List;

public abstract class OnGestureListener
extends TouchRefinery
implements View.OnTouchListener {
    private final Handler altHandler = new Handler();
    private final Handler mainHandler = new Handler();
    private final Runnable doubleTapTimer = new Runnable(){

        @Override
        public void run() {
            OnGestureListener.this.setDoubleTapObj(null);
        }
    };
    private final Runnable preHolding = new Runnable(){

        @Override
        public void run() {
            OnGestureListener.this.heldCount = 0;
            Gesture heldTouch = OnGestureListener.this.getTouchAt(OnGestureListener.this.heldID);
            if (heldTouch != null) {
                if (OnGestureListener.this.debugging()) {
                    Log.e((String)this.getClass().getSimpleName(), (String)"preHolding");
                }
                OnGestureListener.this.onPreHold(heldTouch);
                OnGestureListener.this.mainHandler.postDelayed(OnGestureListener.this.onHolding, OnGestureListener.this.holdDelay(heldTouch));
            }
        }
    };
    private final Runnable onHolding = new Runnable(){

        @Override
        public void run() {
            OnGestureListener.this.isHolding = true;
            OnGestureListener.this.setDoubleTapObj(null);
            Gesture heldTouch = OnGestureListener.this.getTouchAt(OnGestureListener.this.heldID);
            if (heldTouch != null) {
                if (OnGestureListener.this.debugging()) {
                    Log.e((String)this.getClass().getSimpleName(), (String)"onHolding");
                }
                OnGestureListener.this.heldCount++;
                heldTouch.setHold(true);
                OnGestureListener.this.onHold(heldTouch);
                if (OnGestureListener.this.repeatHold(heldTouch)) {
                    OnGestureListener.this.mainHandler.postDelayed(OnGestureListener.this.onHolding, OnGestureListener.this.postHoldDelay(heldTouch));
                }
            }
        }
    };
    private int touchCount;
    private int recentID;
    private boolean doubleTap;
    private int heldID;
    private int heldCount;
    private boolean heldDrag;
    private boolean isHolding;
    private int specialID;
    private RectF specialArea;
    private boolean useLatest;
    private boolean isSpecial;
    private boolean wasSpecial;
    private boolean ranSpecial;
    private boolean heldSpecial;
    private Direction specialDir;
    private int areaID;
    private ArrayList<RectF> areas = new ArrayList();
    private boolean isMultiTouch;

    public OnGestureListener(float pixelSize) {
        super(pixelSize);
    }

    public boolean onTouch(View v, MotionEvent me) {
        if (me == null) {
            return true;
        }
        switch (me.getActionMasked()) {
            case 0: 
            case 5: {
                return this.onDown(this.getID(me), me);
            }
            case 2: {
                if (this.ignoreEvent(this.getID(me))) {
                    return this.onCancel();
                }
                return this.onMove(me);
            }
            case 1: 
            case 6: {
                if (this.ignoreEvent(this.getID(me))) {
                    return this.onCancel();
                }
                return this.onUp(this.getID(me), me);
            }
            case 3: {
                return this.onCancel();
            }
        }
        return v.onTouchEvent(me);
    }

    public final int getRecentID() {
        return this.recentID;
    }

    private int getID(MotionEvent me) {
        return me.getPointerId(me.getActionIndex());
    }

    public final int getHeldCount() {
        return this.heldCount;
    }

    public final boolean isHolding() {
        return this.isHolding;
    }

    public final int getTouchCount() {
        return this.touchCount;
    }

    public final boolean isDoubleTap() {
        return this.doubleTap;
    }

    public final boolean canHoldDrag() {
        return this.heldDrag;
    }

    public final void enableHeldDrag() {
        this.heldDrag = true;
    }

    public final boolean isSpecialDragging() {
        return this.isSpecial;
    }

    public final RectF getSpecialArea() {
        return this.specialArea;
    }

    public final boolean inSpecialArea() {
        return this.specialArea != null;
    }

    public final boolean isMultiTouch() {
        return this.isMultiTouch;
    }

    public final boolean hasSpecialDir() {
        return this.specialDir != Direction.UNDEFINED;
    }

    protected final boolean isSpecialArea(RectF area) {
        return this.inSpecialArea() && area.equals((Object)this.specialArea);
    }

    public final boolean inAnArea() {
        return !this.areas.isEmpty();
    }

    protected final boolean isInArea(RectF area) {
        return this.inAnArea() && this.areas.contains(area);
    }

    protected final boolean isInArea(Gesture touch) {
        return touch.getId() == this.areaID;
    }

    private void clearAltThreads() {
        this.altHandler.removeCallbacksAndMessages(null);
    }

    protected void clearMainThreads() {
        this.mainHandler.removeCallbacksAndMessages(null);
    }

    private Gesture addTouch(Gesture adding) {
        this.setTouchAt(adding.getId(), adding);
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)"addTouch");
        }
        ++this.touchCount;
        return adding;
    }

    private Gesture removeTouch(Gesture removing) {
        this.setTouchAt(removing.getId(), null);
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)"removeTouch");
        }
        --this.touchCount;
        return removing;
    }

    private boolean onDown(int pointerID, MotionEvent me) {
        if (this.touchCount <= 0) {
            this.resetVariables();
        }
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)("onDown----------------" + pointerID + " " + this.touchCount));
        }
        Gesture parent = this.getTouchAt(pointerID - 1);
        float x = me.getX(me.getActionIndex());
        float y = me.getY(me.getActionIndex());
        if (this.useLatest || pointerID == 0 && pointerID != this.touchCount) {
            parent = this.getLatestTouch();
            if (this.useLatest && parent != null && parent.refined()) {
                parent = null;
            }
        }
        this.recentID = pointerID;
        Gesture latest = this.preHolding(this.addTouch(this.doubleTapping(this.preDown(new Gesture(this.createTag(x, y, this.refineX(x), this.refineY(y)), pointerID, this.refineX(x), this.refineY(y), me.getEventTime(), parent)))));
        if (parent != null && parent.canLiberate(this.maxMultiTouch())) {
            latest.setParent(null);
            this.liberateTouches(parent.getLiberator());
            this.useLatest = true;
        }
        return true;
    }

    private Gesture preDown(Gesture onDown) {
        this.determineSpecial(onDown);
        this.determineArea(onDown);
        if (this.canDoubleTap(onDown)) {
            if (this.debugging()) {
                Log.e((String)this.getClass().getSimpleName(), (String)"onDoubleTap");
            }
            this.setDoubleTapObj(null);
            this.doubleTap = true;
            return this.onTap(this.onDoubleTap(onDown));
        }
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)"onTap");
        }
        this.setDoubleTapObj(this.getDoubleTapObj(onDown));
        return this.onTap(onDown);
    }

    private void determineSpecial(Gesture onDown) {
        if (this.canSpecialize(onDown)) {
            RectF[] areas;
            this.specialArea = null;
            for (RectF area : areas = this.getSpecialAreas()) {
                if (!Calculator.contains(onDown.getDownX(), onDown.getDownY(), area)) continue;
                this.specialArea = area;
                this.specialID = onDown.getId();
                if (!this.debugging()) break;
                Log.e((String)this.getClass().getSimpleName(), (String)("canSpecialize " + area.toShortString()));
                break;
            }
        }
    }

    private void determineArea(Gesture onDown) {
        if (this.canBeInAnArea(onDown)) {
            RectF[] rects;
            this.areas.clear();
            for (RectF area : rects = this.getAreas()) {
                if (!Calculator.contains(onDown.getDownX(), onDown.getDownY(), area)) continue;
                this.areas.add(area);
                this.areaID = onDown.getId();
            }
        }
    }

    private boolean canDoubleTap(Gesture onDown) {
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)("canDoubleTap " + this.getDoubleTapObj()));
        }
        if (this.getDoubleTapObj() == null) {
            return false;
        }
        Object latestObj = this.getDoubleTapObj(onDown);
        return latestObj != null && this.getDoubleTapObj().equals(latestObj);
    }

    private Gesture doubleTapping(Gesture onDown) {
        this.clearAltThreads();
        if (this.getDoubleTapObj() != null) {
            if (this.debugging()) {
                Log.e((String)this.getClass().getSimpleName(), (String)"doubleTapping");
            }
            this.altHandler.postDelayed(this.doubleTapTimer, this.doubleTapDelay(onDown));
        }
        return onDown;
    }

    private Gesture preHolding(Gesture onDown) {
        if (this.canHold(onDown)) {
            this.clearMainThreads();
            this.heldID = onDown.getId();
            this.mainHandler.postDelayed(this.preHolding, this.preHoldDelay(onDown));
        }
        return onDown;
    }

    private boolean onMove(MotionEvent me) {
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)"onMove");
        }
        int historySize = me.getHistorySize();
        int pointerCount = me.getPointerCount();
        for (int h = 0; h < historySize; ++h) {
            for (int i = 0; i < pointerCount; ++i) {
                Gesture touch = this.getTouchAt(me.getPointerId(i));
                if (touch == null) continue;
                touch.addPoint(new FPoint(1, this.refineX(me.getHistoricalX(i, h)), this.refineY(me.getHistoricalY(i, h)), me.getHistoricalEventTime(h)));
            }
        }
        for (int i = 0; i < pointerCount; ++i) {
            Gesture touch = this.getTouchAt(me.getPointerId(i));
            if (touch == null) continue;
            touch.addPoint(new FPoint(1, this.refineX(me.getX(i)), this.refineY(me.getY(i)), me.getEventTime()));
        }
        if (!this.isHolding && this.specialArea != null && this.getTouchAt(this.specialID) != null) {
            if (this.debugging()) {
                Log.e((String)this.getClass().getSimpleName(), (String)("onSpecialDrag " + (Object)((Object)this.specialDir)));
            }
            this.onSpecialDrag(this.getTouchAt(this.specialID), this.specialArea);
        } else if (this.heldDrag && this.getTouchAt(this.heldID) != null) {
            if (this.debugging()) {
                Log.e((String)this.getClass().getSimpleName(), (String)"onHeldDrag");
            }
            Gesture heldTouch = this.getTouchAt(this.heldID);
            this.setTouchAt(this.heldID, this.onHeldDrag(heldTouch, this.makeRawX(heldTouch.getUpX()), this.makeRawY(heldTouch.getUpY())));
        }
        return true;
    }

    private void onSpecialDrag(Gesture onDrag, final RectF area) {
        float moveX = onDrag.getUpX();
        float moveY = onDrag.getUpY();
        boolean bl = this.isSpecial = !Calculator.contains(moveX, moveY, this.specialArea);
        if (this.isSpecial) {
            float delta;
            if (!this.hasSpecialDir()) {
                this.specialDir = Calculator.getDirection(onDrag.getDeltaX(), onDrag.getDeltaY(), false);
            }
            this.setDoubleTapObj(null);
            this.clearMainThreads();
            switch (this.specialDir) {
                case LEFT: {
                    delta = area.left - moveX;
                    break;
                }
                case UP: {
                    delta = area.top - moveY;
                    break;
                }
                case RIGHT: {
                    delta = moveX - area.right;
                    break;
                }
                case DOWN: {
                    delta = moveY - area.bottom;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.inSpecialHold(onDrag, area, this.specialDir)) {
                if (!this.ranSpecial) {
                    this.ranSpecial = true;
                    this.altHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (OnGestureListener.this.getTouchAt(OnGestureListener.this.specialID) != null && OnGestureListener.this.touchCount > 0) {
                                OnGestureListener.this.heldSpecial = OnGestureListener.this.onSpecialHold(area);
                            }
                        }
                    }, this.getSpecialDelay(area));
                }
            } else {
                this.onSpecialDrag(onDrag, area, delta, this.specialDir);
                this.ranSpecial = false;
                this.clearAltThreads();
            }
        } else {
            this.onSpecialArea(onDrag, area);
        }
    }

    private boolean onUp(int pointerID, MotionEvent me) {
        Gesture onUp = this.getTouchAt(pointerID);
        onUp.addPoint(new FPoint(3, this.refineX(me.getX(me.getActionIndex())), this.refineY(me.getY(me.getActionIndex())), me.getEventTime()));
        if (onUp.getId() == this.heldID) {
            if (this.debugging()) {
                Log.e((String)this.getClass().getSimpleName(), (String)"onProcessHold");
            }
            this.clearMainThreads();
            this.onProcessHold(onUp);
        }
        if (onUp.getId() == this.specialID) {
            if (this.debugging()) {
                Log.e((String)this.getClass().getSimpleName(), (String)"onProcessSpecial");
            }
            this.wasSpecial = this.onProcessSpecial(onUp, this.specialArea, this.specialDir, this.heldSpecial);
        }
        if (!this.isHolding && !this.wasSpecial) {
            if (this.canMultiTouch(onUp)) {
                if (this.debugging()) {
                    Log.e((String)this.getClass().getSimpleName(), (String)"onMultiTouch");
                }
                boolean bl = this.isMultiTouch = this.onMultiTouch(this.getTouches()) || this.isMultiTouch;
            }
            if (!this.isMultiTouch && !onUp.refined()) {
                this.process(this.refinery(onUp, this.swipeFactor(), this.invertHorizontalSwipes()), false);
            }
        }
        this.removeTouch(onUp);
        if (this.touchCount == 0) {
            this.clearMainThreads();
            this.onRelease(onUp);
        }
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)("onUp------------------" + pointerID + " " + this.touchCount));
        }
        return true;
    }

    protected final void process(List<Gesture> touches, boolean force) {
        this.preprocess();
        for (int i = 0; i < touches.size(); ++i) {
            Gesture touch = touches.get(i);
            if (this.debugging()) {
                Log.e((String)this.getClass().getSimpleName(), (String)(touch.getDownX() + " process " + touch.hasParent() + " " + touch.refined()));
            }
            if (touch.freed()) {
                if (!touch.isHeld()) {
                    this.onProcessTouch(touch);
                }
                this.process(touch.abandonChildren(), force);
            } else if (force) {
                this.onFreedom(touch);
                this.process(this.refinery(touch, this.swipeFactor(), this.invertHorizontalSwipes()), true);
            }
            touch.process();
        }
    }

    public final boolean onCancel() {
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)"onCancel");
        }
        this.clearMainThreads();
        this.clearAltThreads();
        this.clearTouches();
        this.hardReset();
        this.resetVariables();
        return true;
    }

    protected final void liberateTouches(Gesture liberator) {
        if (liberator == null) {
            return;
        }
        this.onLiberate(liberator);
        this.freeTouch(liberator);
        Gesture root = liberator.getRoot();
        if (this.debugging()) {
            Log.e((String)this.getClass().getSimpleName(), (String)("liberateTouches " + root + " " + liberator));
        }
        if (!root.equals(liberator)) {
            if (root.refined()) {
                this.process(root.abandonChildren(), true);
            } else {
                root.refine();
                this.process(this.refinery(root, this.swipeFactor(), this.invertHorizontalSwipes()), true);
            }
        }
    }

    protected final void freeTouches(List<Gesture> touches) {
        for (Gesture touch : touches) {
            this.freeTouch(touch);
        }
    }

    protected final void freeTouch(Gesture touch) {
        if (touch == null) {
            return;
        }
        this.onFreedom(touch);
        this.freeTouches(touch.abandonChildren());
    }

    protected final Direction getMultiTouchDirection(Gesture[] touches) {
        if (this.getTouchCount() != 2 || this.isMultiTouch()) {
            return Direction.UNDEFINED;
        }
        int right = 0;
        int left = 0;
        int down = 0;
        int up = 0;
        int tap = 0;
        Direction dir = Direction.UNDEFINED;
        block6: for (int i = 0; i < this.getTouchCount(); ++i) {
            Gesture touch = touches[i];
            if (touch == null) {
                return Direction.UNDEFINED;
            }
            Direction direction = Calculator.getDirection(touch.getDeltaX(), touch.getDeltaY(), this.invertHorizontalSwipes());
            if (this.tapChecker(touch, direction, touch.getLength(), 1.0f)) {
                if (++tap != this.maxMultiTouch() || !this.multiTouchDirectionEnabled(Direction.TAP)) continue;
                dir = Direction.TAP;
                continue;
            }
            switch (direction) {
                case RIGHT: {
                    if (++right != this.maxMultiTouch() || !this.multiTouchDirectionEnabled(direction)) continue block6;
                    dir = direction;
                    continue block6;
                }
                case LEFT: {
                    if (++left != this.maxMultiTouch() || !this.multiTouchDirectionEnabled(direction)) continue block6;
                    dir = direction;
                    continue block6;
                }
                case DOWN: {
                    if (++down != this.maxMultiTouch() || !this.multiTouchDirectionEnabled(direction)) continue block6;
                    dir = direction;
                    continue block6;
                }
                case UP: {
                    if (++up != this.maxMultiTouch() || !this.multiTouchDirectionEnabled(direction)) continue block6;
                    dir = direction;
                    continue block6;
                }
            }
        }
        return dir;
    }

    private void resetVariables() {
        this.onReset();
        this.recentID = -1;
        this.touchCount = 0;
        this.useLatest = false;
        this.doubleTap = false;
        this.heldID = -1;
        this.heldCount = 0;
        this.heldDrag = false;
        this.isHolding = false;
        this.areaID = -1;
        this.areas.clear();
        this.specialID = -1;
        this.specialArea = null;
        this.isSpecial = false;
        this.wasSpecial = false;
        this.ranSpecial = false;
        this.heldSpecial = false;
        this.specialDir = Direction.UNDEFINED;
        this.isMultiTouch = false;
    }

    protected final float refineX(float x) {
        return x + this.xOffset();
    }

    protected final float refineY(float y) {
        return y + this.yOffset();
    }

    protected final float makeRawX(float x) {
        return x - this.xOffset();
    }

    protected final float makeRawY(float y) {
        return y - this.yOffset();
    }

    protected abstract void onFreedom(Gesture var1);

    protected abstract void onLiberate(Gesture var1);

    protected abstract Object createTag(float var1, float var2, float var3, float var4);

    protected abstract float xOffset();

    protected abstract float yOffset();

    protected abstract float swipeFactor();

    protected abstract boolean invertHorizontalSwipes();

    protected abstract void onReset();

    protected abstract void onHold(Gesture var1);

    protected abstract long holdDelay(Gesture var1);

    protected abstract Gesture onPreHold(Gesture var1);

    protected abstract long preHoldDelay(Gesture var1);

    protected abstract long postHoldDelay(Gesture var1);

    protected abstract long doubleTapDelay(Gesture var1);

    protected abstract boolean canHold(Gesture var1);

    protected abstract boolean repeatHold(Gesture var1);

    protected abstract boolean onProcessHold(Gesture var1);

    protected abstract boolean canSpecialize(Gesture var1);

    protected abstract boolean canBeInAnArea(Gesture var1);

    protected abstract Object getDoubleTapObj(Gesture var1);

    protected abstract Gesture onTap(Gesture var1);

    protected abstract Gesture onDoubleTap(Gesture var1);

    protected abstract Gesture onRelease(Gesture var1);

    protected abstract RectF[] getSpecialAreas();

    protected abstract RectF[] getAreas();

    protected abstract long getSpecialDelay(RectF var1);

    protected abstract boolean onSpecialHold(RectF var1);

    protected abstract Gesture onHeldDrag(Gesture var1, float var2, float var3);

    protected abstract void onSpecialArea(Gesture var1, RectF var2);

    protected abstract boolean inSpecialHold(Gesture var1, RectF var2, Direction var3);

    protected abstract boolean onSpecialDrag(Gesture var1, RectF var2, float var3, Direction var4);

    protected abstract boolean onProcessSpecial(Gesture var1, RectF var2, Direction var3, boolean var4);

    protected abstract boolean canMultiTouch(Gesture var1);

    protected abstract boolean onMultiTouch(Gesture[] var1);

    protected abstract void preprocess();

    protected abstract void onProcessTouch(Gesture var1);

    public abstract void hardReset();

    protected abstract int maxMultiTouch();

    protected abstract boolean multiTouchDirectionEnabled(Direction var1);
}

