/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.content.Context;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.DiskBasedCache;
import com.android.volley.toolbox.HttpStack;
import com.android.volley.toolbox.OkHttp3Stack;
import java.io.File;

public class Volley {
    private static final String DEFAULT_CACHE_DIR = "volley";

    public static RequestQueue newRequestQueue(Context context, HttpStack stack, int maxDiskCacheBytes) {
        File cacheDir = new File(context.getCacheDir(), DEFAULT_CACHE_DIR);
        if (stack == null) {
            stack = new OkHttp3Stack();
        }
        BasicNetwork network = new BasicNetwork(stack);
        RequestQueue queue = maxDiskCacheBytes <= -1 ? new RequestQueue(new DiskBasedCache(cacheDir), network) : new RequestQueue(new DiskBasedCache(cacheDir, maxDiskCacheBytes), network);
        queue.start();
        return queue;
    }

    public static RequestQueue newRequestQueue(Context context, int maxDiskCacheBytes) {
        return Volley.newRequestQueue(context, null, maxDiskCacheBytes);
    }

    public static RequestQueue newRequestQueue(Context context, HttpStack stack) {
        return Volley.newRequestQueue(context, stack, -1);
    }

    public static RequestQueue newRequestQueue(Context context) {
        return Volley.newRequestQueue(context, null);
    }
}

