package com.android.volley.toolbox;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;

/**
 * An {@link HttpStack HttpStack} implementation
 * which uses OkHttp as its transport. For more information:
 * https://gist.github.com/JakeWharton/5616899
 */
public class OkHttp3Stack extends HurlStack {

    private final OkUrlFactory mFactory;

    public OkHttp3Stack() {
        this(new OkHttpClient());
    }

    public OkHttp3Stack(OkHttpClient client) {
        if (client == null) {
            throw new NullPointerException("Client must not be null.");
        }

        mFactory = new OkUrlFactory(client);
    }

    @Override
    protected HttpURLConnection createConnection(URL url) throws IOException {
        return mFactory.open(url);
    }
}