package com.android.volley.manager;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.Volley;

public class RequestManager {

    private final RequestQueue mRequestQueue;

    private static RequestManager sIntance = null;

    private RequestManager(Context context) {
        mRequestQueue = Volley.newRequestQueue(context);
    }

    public static RequestManager getInstance(Context context) {
        if (sIntance == null) {
            synchronized (RequestManager.class) {
                if (sIntance == null) {
                    sIntance = new RequestManager(context.getApplicationContext());
                }
            }
        }
        return sIntance;
    }

    public <T> void addToRequestQueue(Request<T> request, Object tag) {
        if (request == null) {
            return;
        }
        VolleyLog.d("Add to requestQueue : %s TAG : %s", request.getUrl(), tag);
        request.setTag(tag);
        mRequestQueue.add(request);
    }

    public void cancelAllRequestByTag(final Object tag) {
        if (tag == null)
            return;

        VolleyLog.d("Cancelling all requests by tag : %s", tag);
        mRequestQueue.cancelAll(new RequestQueue.RequestFilter() {
            @Override
            public boolean apply(Request<?> request) {
                return request.getTag() != null && request.getTag().equals(tag);
            }
        });
    }

    public void cancelAllRequests() {
        VolleyLog.d("Cancelling all requests");

        mRequestQueue.cancelAll(new RequestQueue.RequestFilter() {
            @Override
            public boolean apply(Request<?> request) {
                return true;
            }
        });
    }


}
