/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.manager;

import android.content.Context;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.Volley;

public class RequestManager {
    private final RequestQueue mRequestQueue;
    private static RequestManager sIntance = null;

    private RequestManager(Context context) {
        this.mRequestQueue = Volley.newRequestQueue(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestManager getInstance(Context context) {
        if (sIntance != null) return sIntance;
        Class<RequestManager> clazz = RequestManager.class;
        synchronized (RequestManager.class) {
            if (sIntance != null) return sIntance;
            sIntance = new RequestManager(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sIntance;
        }
    }

    public <T> void addToRequestQueue(Request<T> request, Object tag) {
        if (request == null) {
            return;
        }
        VolleyLog.d("Add to requestQueue : %s TAG : %s", request.getUrl(), tag);
        request.setTag(tag);
        this.mRequestQueue.add(request);
    }

    public void cancelAllRequestByTag(final Object tag) {
        if (tag == null) {
            return;
        }
        VolleyLog.d("Cancelling all requests by tag : %s", tag);
        this.mRequestQueue.cancelAll(new RequestQueue.RequestFilter(){

            @Override
            public boolean apply(Request<?> request) {
                return request.getTag() != null && request.getTag().equals(tag);
            }
        });
    }

    public void cancelAllRequests() {
        VolleyLog.d("Cancelling all requests", new Object[0]);
        this.mRequestQueue.cancelAll(new RequestQueue.RequestFilter(){

            @Override
            public boolean apply(Request<?> request) {
                return true;
            }
        });
    }
}

