package com.android.volley.toolbox;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * An {@link HttpStack HttpStack} implementation
 * which uses OkHttp as its transport. For more information:
 * https://gist.github.com/JakeWharton/5616899
 */
public class OkHttpStack extends HurlStack {

	private final OkUrlFactory mFactory;

    public OkHttpStack() {
        this(new OkHttpClient());
    }
 
    public OkHttpStack(OkHttpClient client) {
        if (client == null) {
            throw new NullPointerException("Client must not be null.");
        }
       
        mFactory = new OkUrlFactory(client);
    }

	@Override
	protected HttpURLConnection createConnection(URL url) throws IOException {
		return mFactory.open(url);
	}
}