/*
 * Decompiled with CFR 0.152.
 */
package com.fjwangjia.android.seele;

import android.util.Log;
import com.fjwangjia.android.seele.RefectTool;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.Array;

class PatchLoader {
    PatchLoader() {
    }

    void load(File patch, File optDir) {
        this.load(new File[]{patch}, optDir);
    }

    void load(File[] patchs, File optDir) {
        Class<?> clazz;
        if (patchs == null || patchs.length == 0) {
            Log.e((String)"seele_bug_fix", (String)"file paths is empty");
            return;
        }
        String dexPath = "";
        for (File file : patchs) {
            dexPath = dexPath.isEmpty() ? dexPath + file.getAbsolutePath() : dexPath + File.pathSeparator + file.getAbsolutePath();
        }
        DexClassLoader dexClassLoader = new DexClassLoader(dexPath, optDir.getAbsolutePath(), dexPath, this.getClass().getClassLoader());
        ClassLoader appClassLoader = this.getClass().getClassLoader();
        try {
            clazz = Class.forName("dalvik.system.BaseDexClassLoader");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        Object appPathList = RefectTool.getFieldValue(clazz, appClassLoader, "pathList");
        Object dexPathList = RefectTool.getFieldValue(clazz, dexClassLoader, "pathList");
        if (appPathList == null || dexPathList == null) {
            Log.e((String)"Seele_PatchLoader", (String)"reflect dalvik.system.BaseDexClassLoader.pathList fail");
            return;
        }
        Object appEle = RefectTool.getFieldValue(appPathList.getClass(), appPathList, "dexElements");
        Object dexEle = RefectTool.getFieldValue(dexPathList.getClass(), dexPathList, "dexElements");
        if (appEle == null || dexEle == null) {
            Log.e((String)"Seele_PatchLoader", (String)"reflect PathList.dexElements fail");
            return;
        }
        int appEleLength = Array.getLength(appEle);
        int dexEleLength = Array.getLength(dexEle);
        Object dexElements = Array.newInstance(appEle.getClass().getComponentType(), appEleLength + dexEleLength);
        for (int i = 0; i < appEleLength + dexEleLength; ++i) {
            if (i < dexEleLength) {
                Array.set(dexElements, 0, Array.get(dexEle, i));
                continue;
            }
            Array.set(dexElements, dexEleLength, Array.get(appEle, i - dexEleLength));
        }
        RefectTool.setFieldValue(dexPathList.getClass(), appPathList, "dexElements", dexElements);
    }
}

