/*
 * Decompiled with CFR 0.152.
 */
package com.fjwangjia.android.seele;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.security.auth.x500.X500Principal;

public class Verify {
    private static final X500Principal DEBUG_DN = new X500Principal("CN=Android Debug,O=Android,C=US");
    private PublicKey mPublicKey;
    private boolean mDebuggable;

    public Verify(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            String packageName = context.getPackageName();
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 64);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream stream = new ByteArrayInputStream(packageInfo.signatures[0].toByteArray());
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(stream);
            this.mDebuggable = cert.getSubjectX500Principal().equals(DEBUG_DN);
            this.mPublicKey = cert.getPublicKey();
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"Seele Verify", (String)"init", (Throwable)e);
        }
        catch (CertificateException e) {
            Log.e((String)"Seele Verify", (String)"init", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verify(File file) {
        if (this.mDebuggable) {
            Log.d((String)"verify()", (String)"mDebuggable = true");
            return true;
        }
        JarFile jarFile = null;
        try {
            Certificate[] certs;
            jarFile = new JarFile(file);
            JarEntry jarEntry = jarFile.getJarEntry("classes.dex");
            if (null == jarEntry) {
                // empty if block
            }
            if ((certs = jarEntry.getCertificates()) == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.verify(certs);
            return bl;
        }
        catch (IOException e) {
            Log.e((String)"verify", (String)file.getAbsolutePath(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                Log.e((String)"verify", (String)file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private boolean verify(Certificate[] certificates) {
        if (certificates == null && certificates.length == 0) {
            return false;
        }
        for (int i = certificates.length - 1; i >= 0; --i) {
            try {
                certificates[i].verify(this.mPublicKey);
                return true;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return false;
    }
}

