/*
 * Decompiled with CFR 0.152.
 */
package com.fjwangjia.android.seele;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.fjwangjia.android.seele.FileTool;
import com.fjwangjia.android.seele.PatchLoader;
import com.fjwangjia.android.seele.Verify;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class BugFix {
    static String BASE_URL = "";
    static String PATCH_DIR = "";
    static String PATCH_FILE = "apk.patch";
    static String DEX_OPT_DIR = "OPT_DIR";
    static String PERSISTENCE_NAME = "SEELE_BUG_FIX";
    static String LAST_VERSION = "LAST_VERSION";
    static Context mContext = null;
    static int mCurrentVersion;
    static Verify mVerify;
    static PatchLoader mPatchLoader;
    static Handler mHandler;

    public static void init(Context context) {
        File file;
        mContext = context;
        BASE_URL = context.getFilesDir() + "PATCH_DIR/";
        PATCH_DIR = BASE_URL + mCurrentVersion + '/';
        mVerify = new Verify(context);
        mPatchLoader = new PatchLoader();
        mCurrentVersion = 0;
        try {
            String pkName = context.getPackageName();
            mCurrentVersion = context.getPackageManager().getPackageInfo((String)pkName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        int iRecordVersion = BugFix.getRecordVersion(context);
        if (iRecordVersion < mCurrentVersion) {
            BugFix.cleanPatch();
        }
        if (!(file = new File(PATCH_DIR)).exists()) {
            file.mkdirs();
        } else {
            BugFix.loadPatch();
        }
    }

    public static int getRecordVersion(Context context) {
        if (null != context) {
            SharedPreferences sp = context.getSharedPreferences(PERSISTENCE_NAME, 0);
            return sp.getInt(LAST_VERSION, -1);
        }
        return 0;
    }

    public static void setRecordVersion(Context context, int version) {
        SharedPreferences sp = context.getSharedPreferences(PERSISTENCE_NAME, 0);
        sp.edit().putInt(LAST_VERSION, version).commit();
    }

    private static void loadPatch() {
        File patchDir = new File(PATCH_DIR);
        ArrayList<File> patchList = new ArrayList<File>();
        for (File patch : patchDir.listFiles()) {
            if (patch.isFile() && mVerify.verify(patch)) {
                patchList.add(patch);
                continue;
            }
            Log.e((String)"seele_bug_fix", (String)("verify fail or is dir" + patch.getAbsolutePath()));
        }
        if (patchList.size() != 0) {
            File dexOptDir = new File(PATCH_DIR, DEX_OPT_DIR);
            dexOptDir.mkdir();
            mPatchLoader.load((File[])patchList.toArray(), dexOptDir);
        }
    }

    public static void loadPatch(File src) {
        File dest = new File(PATCH_DIR, PATCH_FILE);
        if (src == null || !src.exists()) {
            Log.e((String)"seele_bug_fix", (String)("there is not exists file : " + src.getAbsolutePath()));
            return;
        }
        if (dest.exists() && !dest.delete()) {
            return;
        }
        if (!mVerify.verify(src)) {
            Log.e((String)"seele_bug_fix", (String)("verify fail" + src.getAbsolutePath()));
            return;
        }
        try {
            FileTool.copyFile(src, dest);
            File dexOptDir = new File(PATCH_DIR, DEX_OPT_DIR);
            dexOptDir.mkdir();
            mPatchLoader.load(dest, dexOptDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadPatch(String path) {
        if (path == null) {
            Log.e((String)"seele loadPatch:", (String)" path is null");
            return;
        }
        if (path.startsWith("http")) {
            new DownloadPatchThread(path).start();
            return;
        }
        File src = new File(path);
        BugFix.loadPatch(src);
    }

    public static void cleanPatch() {
        if (mContext != null) {
            File baseDir = new File(BASE_URL);
            FileTool.deleteDir(baseDir);
        }
    }

    static {
        mVerify = null;
        mPatchLoader = null;
        mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                BugFix.loadPatch();
            }
        };
    }

    private static class DownloadPatchThread
    extends Thread {
        String mDownUrl;

        public DownloadPatchThread(String downUrl) {
            this.mDownUrl = downUrl;
        }

        @Override
        public void run() {
            try {
                if (Environment.getExternalStorageState().equals("mounted")) {
                    URL url = new URL(this.mDownUrl);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.connect();
                    int length = conn.getContentLength();
                    InputStream is = conn.getInputStream();
                    File file = new File(PATCH_DIR);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    File apkFile = new File(PATCH_DIR, PATCH_FILE);
                    FileOutputStream fos = new FileOutputStream(apkFile);
                    byte[] buf = new byte[1024];
                    Log.d((String)"down patch from", (String)this.mDownUrl);
                    while (true) {
                        int numread;
                        if ((numread = is.read(buf)) <= 0) break;
                        fos.write(buf, 0, numread);
                    }
                    Log.d((String)"down patch ", (String)" complete");
                    mHandler.sendEmptyMessage(0);
                    fos.close();
                    is.close();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

